<?php

namespace App\Traits\BootTrait;

use App\Models\User;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Route;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

trait CreatedByUpdatedByIdTrait
{
    protected static function boot()
    {
        parent::boot(); // TODO: Change the autogenerated stub
        $registerRoute = Route::has('register') ? route('register') : '';
       
        #Creating
        static::creating(function ($model) use($registerRoute){
            $model->created_by_id = userID();
            if(in_array(URL::current(), [$registerRoute]) && isAdmin()) {
                if($model->getTable() != 'users'){
                    $model->user_id = session('s_customer_id');
                    session()->forget('s_customer_id');
                }
            }
            else if($model->getTable() != 'users') {
                $model->user_id = getAdminOrCustomerId() ?? 1; // userID();
            }

            // subscription_user_id
//            if($model->hasColumn('subscription_user_id')  && !isAdmin()) {
//                $model->subscription_user_id = 1; // userID();
//            }
//
//            if ($model->hasColumn('subscription_plan_id') && !isAdmin()) {
//                $model->subscription_plan_id = 1;
//            }

        });

        # Updating
        static::updating(function ($model){
            $model->updated_by_id = isLoggedIn() ? userID() : null;

            if($model->getTable() != 'users') {
                $model->user_id = getAdminOrCustomerId() ?? 1; // userID();
            }
        });
    }
}
