<form action="{{ route('admin.template-categories.store') }}" method="POST" id="addTemplateCategoryForm">
    <div class="offcanvas offcanvas-end" id="addTemplateCategoryFormSidebar" tabindex="-1">
        @method('POST')
        @csrf
        <x-form.input name="id" id="id" type="hidden" value="" showDiv=0 />
        <div class="offcanvas-header border-bottom py-3">
            <h5 class="offcanvas-title">{{ localize('Add Template Category') }}</h5>
            <span class="tt-close-btn" data-bs-dismiss="offcanvas">
                <i data-feather="x"></i>
            </span>
        </div>
        <x-common.splitter />
        <div class="offcanvas-body">
            <x-common.message class="mb-3" />

            <div class="mb-3">
                <x-form.label for="category_name" label="{{ localize('Name') }}" isRequired=true />
                <x-form.input name="category_name" id="category_name"
                              type="text"
                              placeholder="{{ localize('Name') }}"
                              value=""
                              showDiv=false
                />
            </div>
            <div class="mb-3">
                    <x-form.label for="icon" label="{{ localize('Icon') }}"  />
                    <span><a href="https://icons8.com/line-awesome" target="_blank" rel="noopener noreferrer">{{localize('Get Icons')}}</a></span>

                <x-form.input name="icon" id="icon"
                              type="text"
                              placeholder='<i class="las la-info-circle"></i>'
                              value=""
                              showDiv=false
                />
            </div>

            <div class="mb-3">
                <x-form.label for="is_active" label="{{ localize('Status') }}" />
                <x-form.select name="is_active" id="is_active">
                    @foreach (appStatic()::STATUS_ARR as $dataStatusId => $dataStatus)
                        <option value="{{ $dataStatusId }}">{{ $dataStatus }}</option>
                    @endforeach
                </x-form.select>
            </div>
        </div>
        <div class="offcanvas-footer border-top">
            <div class="d-flex gap-3">
                <x-form.button id="frmActionBtn">{{ localize('Save') }}</x-form.button>
                <x-form.button color="secondary" type="reset">{{ localize('Reset') }}</x-form.button>
            </div>
        </div>
    </div>
</form>
