<div class="card-header">
    <h5 class="mb-0"><?php echo e(localize('All Tickets')); ?></h5>
</div>
<div class="card-body p-0">
    <div class="list-group list-group-flush">
        <?php $__currentLoopData = $tickets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ticket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <a href="<?php echo e(route('admin.support-tickets.reply', $ticket->id)); ?>" target="_blank" class="list-group-item list-group-item-action py-3">
                <div class="d-flex">
                    <div class="avatar avatar-md me-2 flex-shrink-0">
                        <img class="rounded-circle"
                            src="<?php echo e(avatarImage($ticket->createdBy->avatar_id)); ?>" alt="avatar"
                            onerror="this.onerror=null;this.src='<?php echo e(avatarImage($ticket->createdBy->avatar_id)); ?>';">
                    </div>
                    <div class="flex-1">
                        <h6 class="mb-1"><?php echo e($ticket->title); ?> #<?php echo e($ticket->id); ?>

                            <span
                                class="fs-ms fw-medium rounded-pill badge shadow-sm text-black"><?php echo e($ticket->priority->name); ?></span>
                        </h6>
                        <ul class="list-inline mb-0">
                            <li class="list-inline-item">
                                <span class="text-muted"><i data-feather="folder"
                                        class="icon-14 me-1"></i><?php echo e(localize('Category')); ?>:<?php echo e($ticket->category->name); ?>

                                </span>
                            </li>
                            <?php if($ticket->category->staff): ?>
                                <li class="list-inline-item">
                                    <span class="text-muted"><i data-feather="user"
                                            class="icon-14 me-1"></i><?php echo e(localize('Assigned')); ?>:
                                        <?php echo e($ticket->category->staff->name); ?></span>
                                </li>
                            <?php endif; ?>
                            <li class="list-inline-item">
                                <span class="text-muted"><i data-feather="calendar"
                                        class="icon-14 me-1"></i><?php echo e(localize('Date')); ?>:
                                    <?php echo e(date('d-M-y h:i:s A', strtotime($ticket->created_at))); ?></span>
                            </li>
                        </ul>
                    </div>
                </div>
            </a>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


    </div>
</div>
<div class="card-footer">
    <div class="d-flex align-items-center justify-content-between">
        <span><?php echo e($tickets->firstItem() ?? 0); ?>-<?php echo e($tickets->lastItem() ?? 0); ?>

            <?php echo e(localize('of')); ?>

            <?php echo e($tickets->total()); ?> <?php echo e(localize('results')); ?></span>
        <nav>
            <?php echo e($tickets->appends(request()->input())->onEachSide(0)->links()); ?>

        </nav>
    </div>
</div><?php /**PATH /home/u191805559/domains/aitwl.com/public_html/resources/views/backend/admin/support/tickets/list-of-ticket.blade.php ENDPATH**/ ?>