<table class="table tt-footable align-middle" data-use-parent-width="true">
    <thead>
        <tr>
            <th class="text-center"><?php echo e(localize('S/L')); ?></th>
            <th><?php echo e(localize('User')); ?></th>
            <?php if(isCustomerUserGroup()): ?>
                <th data-breakpoints="xs sm"><?php echo e(localize('Referred By')); ?></th>
            <?php endif; ?>
            <th data-breakpoints="xs sm md"><?php echo e(localize('Package')); ?></th>
            <th data-breakpoints="xs sm"><?php echo e(localize('Rate')); ?></th>
            <th data-breakpoints="xs sm"><?php echo e(localize('Earning')); ?></th>
            <th data-breakpoints="xs sm" class="text-center"><?php echo e(localize('Date')); ?></th>
        </tr>
    </thead>
    <tbody>
        <?php $__currentLoopData = $earningHistories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $history): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td class="text-center">
                    <?php echo e($key + 1 + ($earningHistories->currentPage() - 1) * $earningHistories->perPage()); ?>

                </td>
                <td>
                    <a href="javascript:void(0);" class="d-flex align-items-center">
                        <div class="avatar avatar-sm">
                            <img class="rounded-circle"
                                 src="<?php echo e(urlVersion($history->user->avatar)); ?>"
                                 alt=""
                                onerror="this.onerror=null;this.src='<?php echo e(urlVersion('backend/assets/img/placeholder-thumb.png')); ?>';" />
                        </div>
                        <h6 class="fs-sm mb-0 ms-2"><?php echo e($history->user->name); ?>

                        </h6>
                    </a>
                </td>

                <?php if(isCustomerUserGroup()): ?>
                    <td>
                        <a href="javascript:void(0);" class="d-flex align-items-center">
                            <div class="avatar avatar-sm">
                                <img class="rounded-circle" src="<?php echo e(urlVersion($history->referredBy?->avatar)); ?>"
                                    alt=""
                                    onerror="this.onerror=null;this.src='<?php echo e(urlVersion('backend/assets/img/placeholder-thumb.png')); ?>';" />
                            </div>
                            <h6 class="fs-sm mb-0 ms-2"><?php echo e($history->referredBy?->name); ?>

                            </h6>
                        </a>
                    </td>
                <?php endif; ?>

                <td>
                    <div>
                        <?php echo e($history->subscriptionPlan?->plan?->title); ?>/<?php echo e($history->subscriptionPlan?->plan?->package_type); ?>

                    </div>
                    <span
                        class="fw-bold"><?php echo e(formatPrice($history->subscriptionPlan ? $history->subscriptionPlan->price : 0)); ?></span>
                </td>

                <td>
                    <?php echo e($history->commission_rate); ?>%
                </td>

                <td>
                    <?php echo e(formatPrice($history->amount,true)); ?>

                </td>

                <td class="text-center">
                    <?php echo e(date('d M, Y', strtotime($history->created_at))); ?>

                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>

<!--pagination start-->
<div class="d-flex align-items-center justify-content-between px-4 pb-4">
    <span><?php echo e(localize('Showing')); ?>

        <?php echo e($earningHistories->firstItem()); ?>-<?php echo e($earningHistories->lastItem()); ?>

        <?php echo e(localize('of')); ?>

        <?php echo e($earningHistories->total()); ?> <?php echo e(localize('results')); ?></span>
    <nav>
        <?php echo e($earningHistories->appends(request()->input())->links()); ?>

    </nav>
</div>
<!--pagination end-->
<?php /**PATH /home/u191805559/domains/aitwl.com/public_html/resources/views/backend/admin/affiliate/inc/earningHistoryTable.blade.php ENDPATH**/ ?>