
<div class="content-generator__sidebar content-generator__sidebar--end bg-secondary-subtle">
    <div class="content-generator__sidebar-header p-3 bg-white">
        <h5 class="mb-0">
            <?php echo e(localize('Post accounts and Preview')); ?>

        </h5>
    </div>
    <div class="border-top">
        <div class="p-3">
            <h6><?php echo e(localize('Select Posting Profiles')); ?></h6>
            <div class="form-check">
                <input class="form-check-input" type="checkbox" id="select-all-checker">
                <label class="form-check-label cursor-pointer" for="select-all-checker"><?php echo e(localize('Select All')); ?></label>
            </div>
            <?php $__currentLoopData = $platformAccounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $platformAccount): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="form-check d-flex align-items-center mb-2">
                    <input class="form-check-input platform_account_ids" name="platform_account_ids[]" value="<?php echo e($platformAccount->id); ?>" type="checkbox" id="<?php echo e($platformAccount->id); ?>"> 
                    <label class="form-check-label cursor-pointer ms-2" for="<?php echo e($platformAccount->id); ?>">
                        <div class="d-flex align-items-center">
                            <img src="<?php echo e(decodedFieldValue($platformAccount->account_details, 'avatar_thumbnail')); ?>" alt=" " width="25" class="me-2">
                            <span><?php echo e($platformAccount->account_name); ?></span>
                            (<img src="<?php echo e(mediaImage($platformAccount->platform?->icon_media_manager_id)); ?>" alt=" " width="20" height="16">)
                        </div>
                    </label>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>

    
    <ul class="nav c_post tt-grid fw-medium sticky-top bg-light-subtle border-bottom p-3">
        <?php $__currentLoopData = $platforms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $platform): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if(hasPlatformAccess($platform)): ?>
                <li class="nav-item">
                    <a href="#<?php echo e($platform->slug); ?>-preview" class="d-flex align-items-center border rounded-pill px-2 py-1 tt-grid-item">
                        <span>
                            <img src="<?php echo e(mediaImage($platform->icon_media_manager_id)); ?>" alt="<?php echo e($platform->name); ?>" width="30">
                        </span>
                        <span class="ms-1"><?php echo e($platform->name); ?></span>
                    </a>
                </li>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>

    <div class="content-generator__sidebar-body tt-custom-scrollbar overflow-y-auto tt-screen-height pt-0">
        <?php $__currentLoopData = $platforms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $platform): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if(hasPlatformAccess($platform)): ?>
                <div class="mt-4 shadow-sm p-3 rounded bg-light-subtle tt-single-post" id="<?php echo e($platform->slug); ?>-preview">
                    <div class="d-flex align-items-center justify-content-between mb-3">
                        <div class="d-flex align-items-center gap-2">
                            <div class="avatar avatar-md">
                                <img class="rounded-circle" src="<?php echo e(mediaImage($platform->icon_media_manager_id)); ?>" alt="<?php echo e($platform->name); ?>" alt="<?php echo e($platform->name); ?>" />
                            </div>
                            <div>
                                <h6 class="mb-0">John Denver</h6>
                                <small class="text-muted"> <?php echo e(\Carbon\Carbon::now()->format('d M, Y')); ?></small>
                            </div>
                        </div>
                        <span class="text-muted">
                            <i data-feather="more-horizontal" class="icon-18"></i>
                        </span>
                    </div>

                    <div class="mb-3 tt-line-clamp tt-clamp-3 preview-div" id="<?php echo e($platform->slug); ?>_preview_text"></div>
    
                    <div class="tt-caption-img-wrap position-relative post-preview-image tt-img-one">
                        <div class="tt-caption-img">
                            <img src="<?php echo e(asset('assets/img/preview-img.png')); ?>" alt="preview" class="img-fluid">
                        </div>
                    </div> 

                    <div class="tt-post-action d-flex justify-content-between mt-3 text-muted">
                        <?php switch($platform->slug):
                            case (appStatic()::PLATFORM_FACEBOOK): ?>
                                <span class="fs-sm"><i data-feather="thumbs-up" class="icon-16"></i> <?php echo e(localize('Like')); ?></span>
                                <span class="fs-sm"><i data-feather="message-circle" class="icon-16"></i> <?php echo e(localize('Comment')); ?></span>
                                <span class="fs-sm"><i data-feather="share-2" class="icon-16"></i> <?php echo e(localize('Share')); ?></span>
                                <?php break; ?>
                            <?php case (appStatic()::PLATFORM_INSTAGRAM): ?>
                                <i data-feather="heart" class="icon-16"></i>
                                <i data-feather="message-circle" class="icon-16"></i>
                                <i data-feather="send" class="icon-16"></i>
                                <i data-feather="bookmark" class="icon-16"></i>
                                <?php break; ?>
                            <?php case (appStatic()::PLATFORM_TWITTER): ?>
                                <i data-feather="message-circle" class="icon-16"></i>
                                <i data-feather="repeat" class="icon-16"></i>
                                <i data-feather="heart" class="icon-16"></i>
                                <i data-feather="share" class="icon-16"></i>
                                <?php break; ?>
                            <?php case (appStatic()::PLATFORM_LINKEDIN): ?>
                                <span class="fs-sm"><i data-feather="thumbs-up" class="icon-16"></i> <?php echo e(localize('Like')); ?></span>
                                <span class="fs-sm"><i data-feather="message-square" class="icon-16"></i> <?php echo e(localize('Comment')); ?></span>
                                <span class="fs-sm"><i data-feather="share-2" class="icon-16"></i> <?php echo e(localize('Share')); ?></span>
                                <span class="fs-sm"><i data-feather="send" class="icon-16"></i> <?php echo e(localize('Send')); ?></span>
                                <?php break; ?>
                            <?php default: ?>
                        <?php endswitch; ?>
                    </div>
                </div> 
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div><?php /**PATH /home/u191805559/domains/aitwl.com/public_html/Modules/SocialPilot/resources/views/posts/inc/accounts-and-preview.blade.php ENDPATH**/ ?>