<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag; ?>
<?php foreach($attributes->onlyProps([
    "total",
    "used",
    "remaining",

]) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $attributes = $attributes->exceptProps([
    "total",
    "used",
    "remaining",

]); ?>
<?php foreach (array_filter(([
    "total",
    "used",
    "remaining",

]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $__defined_vars = get_defined_vars(); ?>
<?php foreach ($attributes as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
} ?>
<?php unset($__defined_vars); ?>

<?php
    $percentageUsed = ($used == 0) ? 100 : ($used / $total) * 100;
?>


    <div class="d-flex align-items-center flex-column bg-light-subtle px-3 py-2 rounded">
        <div class="d-flex justify-content-between w-100 fs-md lh-1 mb-2">
            <span>
                <?php echo e(localize("Total")); ?>: <strong class="balanceTotal"><?php echo e($total); ?> </strong>
            </span>

            <span class="ms-4">
                <?php echo e(localize("Remaining Balance")); ?>: <strong class="balanceRemaining"><?php echo e($remaining); ?></strong>
            </span>
        </div>

        <div class="progress w-100 mb-1" style="height: 4px;">
            <div class="progress-bar bg-warning balanceProgressBar"
                 role="progressbar"
                 style="width: <?php echo e(100 - $percentageUsed); ?>%"
                 aria-valuenow="<?php echo e($used); ?>"
                 aria-valuemin="0"
                 aria-valuemax="100">
            </div>
        </div>
    </div>
<?php /**PATH /home/u191805559/domains/aitwl.com/public_html/resources/views/components/common/balance-component.blade.php ENDPATH**/ ?>