<section class="pb-120">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-6">
                <div class="text-center mb-40">
                    <div class="d-inline-block text-center px-5 py-1 rounded-pill border border-1 border-primary mb-4">
                        <p class="fs-14 fw-normal mb-0"><?php echo e(localize('Pricing Plans')); ?></p>
                    </div>

                    <h2 class="fs-48 mb-0"><?php echo e(localize('Flexible Pricing That Suits Your Needs')); ?></h2>
                </div>
            </div>
        </div>
        <div class="tab-nav d-flex justify-content-center">
            <ul class="nav nav-pills d-inline-flex justify-content-center align-items-center gap-1 wt_card_style_nhover rounded-pill px-3 py-2"
                id="myTab2" role="tablist">
                <li class="nav-item" role="presentation">
                    <a href="#" class="nav-link text-body fw-normal px-4 py-1 rounded-pill  planType active" data-type="<?php echo e(appStatic()::PLAN_TYPE_MONTHLY); ?>"
                        data-bs-toggle="pill" data-bs-target="#price-1" type="button" role="tab"
                        aria-selected="true">
                        <span>
                            <?php echo e(localize('Monthly')); ?>

                        </span>
                    </a>
                </li>
                <li class="nav-item" role="presentation">
                    <a href="#" class="nav-link text-body fw-normal px-4 py-1 rounded-pill planType" data-type="<?php echo e(appStatic()::PLAN_TYPE_YEARLY); ?>" data-bs-toggle="pill"
                        data-bs-target="#price-2" type="button" role="tab" aria-selected="true">
                        <span>
                            <?php echo e(localize('Yearly')); ?>

                        </span>
                    </a>
                </li>
                <li class="nav-item" role="presentation">
                    <a href="#" class="nav-link text-body fw-normal px-4 py-1 rounded-pill planType" data-type="<?php echo e(appStatic()::PLAN_TYPE_LIFETIME); ?>" data-bs-toggle="pill"
                        data-bs-target="#price-3" type="button" role="tab" aria-selected="true">
                        <span>
                            <?php echo e(localize('Lifetime')); ?>

                        </span>
                    </a>
                </li>
                <li class="nav-item" role="presentation">
                    <a href="#" class="nav-link text-body fw-normal px-4 py-1 rounded-pill planType" data-type="<?php echo e(appStatic()::PLAN_TYPE_PREPAID); ?>" data-bs-toggle="pill"
                        data-bs-target="#price-4" type="button" role="tab" aria-selected="true">
                        <span>
                            <?php echo e(localize('Prepaid')); ?>

                        </span>
                    </a>
                </li>
            </ul>
        </div>
        <div class="tab-content mt-10" id="myTabContent2">
            <div class="tab-pane fade active show" id="price-1" role="tabpanel">
                <div class="row justify-content-center overflow-hidden mb-3 g-0 g-x-0" id="plan-list">
                    <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $package_type = $package->package_type == appStatic()::PLAN_TYPE_STARTER ? '' : $package->package_type;
                            $price =
                                $package->discount_status && $package->discount_price
                                    ? $package->discount_price
                                    : $package->price;
                        ?>
                        <div class="col-md-6 col-xl-3">
                            <div
                                class="price-item bg-white bg-opacity-5 p-8 border border-white border-opacity-5 position-relative h-100">
                                <?php if($package->is_featured == 1): ?>
                                    <div class="discount-badge bg-gradient-1"><i class="las la-check"></i></div>
                                <?php endif; ?>
                                <h6 class="text-gradient-2 mb-3"> <?= html_entity_decode($package->title) ?> </h6>
                                <small class="text-body mb-4 d-inline-block"> <?php echo html_entity_decode($package->description); ?> </small>
                                <h3 class="text-body mb-8 d-flex align-items-center gap-2">
                                    <span class="text-gradient-2 fs-14 -mt-10"></span>
                                    <?php if($package->package_type == 'starter'): ?>
                                            <?php echo e(localize('Free')); ?>

                                    <?php else: ?>
                                            <?php echo e($price ? formatPrice($price) : localize('Free')); ?>

                                        <del class="">
                                            <?php echo e($package->discount_status && $package->discount_price ? formatPrice($package->price) : ''); ?>

                                        </del>
                                    <?php endif; ?>

                                    <?php if($price): ?>
                                        <span class="text-gradient-2 fs-14 fw-normal">
                                            <?php echo e(localize('per')); ?> <?php echo e(localize(ucfirst($package_type))); ?>

                                        </span>
                                    <?php endif; ?>
                                </h3>


                                <button type="button"
                                        class="btn border border-white border-opacity-25 px-3 py-2 fw-normal rounded-pill d-inline-flex align-items-center gap-3 mb-10"
                                        data-package-id="<?php echo e($package->id); ?>" data-price="<?php echo e($package->price); ?>"
                                        data-package-type="<?php echo e($package->package_type); ?>"
                                        data-previous-package-type="<?php echo e($package->package_type); ?>"
                                        data-user-type="<?php echo e(isLoggedIn() ? appStatic()::USER_TYPES[user()->user_type] : 'unauthorized'); ?>"
                                        onclick="handlePackagePayment(this)"
                                   <?php if(isLoggedIn()): ?>
                                       role="button"
                                   <?php endif; ?>
                                >
                                    <?php if($package->package_type == 'starter'): ?>
                                        <svg width="24" height="25" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <rect y="0.5" width="24" height="24" rx="12" fill="white"/>
                                        <path d="M6.43862 12.1525C6.43862 12.1525 12.4477 12.1525 17.8672 12.1525M17.8672 12.1525C13.9522 12.1525 13.2295 8.15253 13.2295 8.15253M17.8672 12.1525C13.9522 12.1525 13.2295 16.1525 13.2295 16.1525" stroke="#553BF9" stroke-width="1.1"/>
                                        </svg> <?php echo e(localize('Try For Free')); ?>

                                    <?php else: ?>
                                    <svg width="24" height="25" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <rect y="0.5" width="24" height="24" rx="12" fill="white"/>
                                    <path d="M6.43862 12.1525C6.43862 12.1525 12.4477 12.1525 17.8672 12.1525M17.8672 12.1525C13.9522 12.1525 13.2295 8.15253 13.2295 8.15253M17.8672 12.1525C13.9522 12.1525 13.2295 16.1525 13.2295 16.1525" stroke="#553BF9" stroke-width="1.1"/>
                                    </svg>
                                        <?php echo e(localize('Subscribe Now')); ?>

                                    <?php endif; ?>
                                </button>

                                <h6 class="text-heading fs-16 mb-5">
                                    <?php echo e(localize('Included Featured:')); ?></h6>
                                <ul class="list-unstyled mb-0 d-flex flex-column gap-3">
                                    <?php if($package->show_open_ai_model != 0): ?>
                                        <li class="d-flex align-items-center gap-4">
                                            <span
                                                class="w-6 h-6 flex-shrink-0 bg-white bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center">
                                                <span class="text-body fs-12"><i class="las la-check"></i></span>
                                            </span>
                                            <p class="mb-0 text-body fs-14 fw-normal">
                                                <?php echo e(openAiModelName($package->openai_model)); ?></p>
                                        </li>
                                    <?php endif; ?>
                                    <?php if($package->allow_words != 0): ?>
                                        <li class="d-flex align-items-center gap-4">
                                            <span
                                                class="w-6 h-6 flex-shrink-0 <?php echo e($package->allow_words == 1 ? 'bg-success' : 'bg-danger'); ?> bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center">
                                                <span class="text-body fs-12"><i
                                                        class="<?php echo e($package->allow_words == 1 ? 'las la-check' : 'text-danger las la-times'); ?>"></i></span>
                                            </span>
                                            <p class="mb-0 text-body fs-14 fw-normal"> <strong class="me-1">
                                                    <?php echo e($package->allow_unlimited_word == 1 ? localize('Unlimited') : $package->total_words_per_month); ?>

                                                </strong><?php echo e(localize('Words')); ?></p>
                                        </li>
                                    <?php endif; ?>
                                    <?php if(getSetting('enable_templates') && $package->show_templates != 0): ?>
                                        <li class="d-flex align-items-center gap-4">
                                            <span
                                                class="w-6 h-6 flex-shrink-0 <?php echo e($package->allow_words == 1 ? 'bg-success' : 'bg-danger'); ?> bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center">
                                                <span class="text-body fs-12"><i
                                                        class="<?php echo e($package->allow_words == 1 ? 'las la-check' : 'text-danger las la-times'); ?>"></i></span>
                                            </span>
                                            <p class="mb-0 text-body fs-14 fw-normal"><span>
                                                    <span  class="text-decoration-none text-body">
                                                        <strong
                                                            class="fw-normal"><?php echo e($package->subscription_plan_templates->count()); ?></strong>
                                                        <?php echo e(localize('AI Templates')); ?>

                                                    </span>
                                                </span></p>
                                        </li>
                                    <?php endif; ?>
                                    <?php if(getSetting('enable_ai_chat') != '0' && $package->show_ai_chat != 0): ?>
                                        <li class="d-flex align-items-center gap-4">
                                            <span
                                                class="w-6 h-6 flex-shrink-0 <?php echo e($package->show_ai_chat == 1 ? 'bg-success' : 'bg-danger'); ?> bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center">
                                                <span class="text-body fs-12"><i
                                                        class="<?php echo e($package->allow_ai_chat == 1 ? 'las la-check' : 'text-danger las la-times'); ?>"></i></span>
                                            </span>
                                            <p class="mb-0 text-body fs-14 fw-normal"> <?php echo e(localize('AI Chat')); ?>

                                            </p>
                                        </li>
                                    <?php endif; ?>
                                    <?php if(getSetting('enable_ai_chat') != '0' && $package->show_real_time_data != 0): ?>
                                        <li class="d-flex align-items-center gap-4">
                                            <span
                                                class="w-6 h-6 flex-shrink-0 <?php echo e($package->show_real_time_data == 1 ? 'bg-success' : 'bg-danger'); ?> bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center">
                                                <span class="text-body fs-12"><i
                                                        class="<?php echo e($package->allow_real_time_data == 1 ? 'las la-check' : 'text-danger las la-times'); ?>"></i></span>
                                            </span>
                                            <p class="mb-0 text-body fs-14 fw-normal">
                                                <?php echo e(localize('Chat Real Time Data')); ?></p>
                                        </li>
                                    <?php endif; ?>
                                    <?php if(getSetting('enable_ai_rewriter') != '0' && $package->show_ai_rewriter != 0): ?>
                                        <li class="d-flex align-items-center gap-4">
                                            <span
                                                class="w-6 h-6 flex-shrink-0 <?php echo e($package->show_ai_rewriter == 1 ? 'bg-success' : 'bg-danger'); ?> bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center">
                                                <span class="text-body fs-12"><i
                                                        class="<?php echo e($package->allow_ai_rewriter == 1 ? 'las la-check' : 'text-danger las la-times'); ?>"></i></span>
                                            </span>
                                            <p class="mb-0 text-body fs-14 fw-normal">
                                                <?php echo e(localize('AI Rewriter')); ?></p>
                                        </li>
                                    <?php endif; ?>
                                    <?php if(getSetting('enable_ai_vision') != '0' && $package->show_ai_vision != 0): ?>
                                        <li class="d-flex align-items-center gap-4">
                                            <span
                                                class="w-6 h-6 flex-shrink-0 <?php echo e($package->allow_ai_vision == 1 ? 'bg-success' : 'bg-danger'); ?> bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center">
                                                <span class="text-body fs-12"><i
                                                        class="<?php echo e($package->allow_ai_vision == 1 ? 'las la-check' : 'text-danger las la-times'); ?>"></i></span>
                                            </span>
                                            <p class="mb-0 text-body fs-14 fw-normal"> <?php echo e(localize('AI Vision')); ?>

                                            </p>
                                        </li>
                                    <?php endif; ?>
                                    <?php if(getSetting('enable_ai_pdf_chat') != '0' && $package->show_ai_pdf_chat != 0): ?>
                                        <li class="d-flex align-items-center gap-4">
                                            <span
                                                class="w-6 h-6 flex-shrink-0 <?php echo e($package->allow_ai_pdf_chat == 1 ? 'bg-success' : 'bg-danger'); ?> bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center">
                                                <span class="text-body fs-12"><i
                                                        class="<?php echo e($package->allow_ai_pdf_chat == 1 ? 'las la-check' : 'text-danger las la-times'); ?>"></i></span>
                                            </span>
                                            <p class="mb-0 text-body fs-14 fw-normal">
                                                <?php echo e(localize('AI PDF Chat')); ?></p>
                                        </li>
                                    <?php endif; ?>
                                    <?php if(getSetting('enable_generate_code') != '0' && $package->show_ai_code != 0): ?>
                                        <li class="d-flex align-items-center gap-4">
                                            <span
                                                class="w-6 h-6 flex-shrink-0 <?php echo e($package->show_ai_code == 1 ? 'bg-success' : 'bg-danger'); ?> bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center">
                                                <span class="text-body fs-12"><i
                                                        class="<?php echo e($package->allow_ai_code == 1 ? 'las la-check' : 'text-danger las la-times'); ?>"></i></span>
                                            </span>
                                            <p class="mb-0 text-body fs-14 fw-normal"> <?php echo e(localize('AI Code')); ?>

                                            </p>
                                        </li>
                                    <?php endif; ?>
                                    <?php if(getSetting('enable_blog_wizard') != '0' && $package->show_blog_wizard != 0): ?>
                                        <li class="d-flex align-items-center gap-4">
                                            <span
                                                class="w-6 h-6 flex-shrink-0 <?php echo e($package->allow_blog_wizard == 1 ? 'bg-success' : 'bg-danger'); ?> bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center">
                                                <span class="text-body fs-12"><i
                                                        class="<?php echo e($package->allow_blog_wizard == 1 ? 'las la-check' : 'text-danger las la-times'); ?>"></i></span>
                                            </span>
                                            <p class="mb-0 text-body fs-14 fw-normal">
                                                <?php echo e(localize('AI Blog Wizard')); ?></p>
                                        </li>
                                    <?php endif; ?>
                                    <?php if(getSetting('enable_ai_plagiarism') != '0' && $package->show_ai_plagiarism): ?>
                                        <li class="d-flex align-items-center gap-4">
                                            <span
                                                class="w-6 h-6 flex-shrink-0 <?php echo e($package->allow_ai_plagiarism == 1 ? 'bg-success' : 'bg-danger'); ?> bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center">
                                                <span class="text-body fs-12"><i
                                                        class="<?php echo e($package->allow_ai_plagiarism == 1 ? 'las la-check' : 'text-danger las la-times'); ?>"></i></span>
                                            </span>
                                            <p class="mb-0 text-body fs-14 fw-normal">
                                                <?php echo e(localize('AI Plagiarism')); ?></p>
                                        </li>
                                    <?php endif; ?>
                                    <?php if(getSetting('enable_ai_detector') != '0' && $package->show_ai_detector): ?>
                                        <li class="d-flex align-items-center gap-4">
                                            <span
                                                class="w-6 h-6 flex-shrink-0 <?php echo e($package->allow_ai_detector == 1 ? 'bg-success' : 'bg-danger'); ?> bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center">
                                                <span class="text-body fs-12"><i
                                                        class="<?php echo e($package->allow_ai_detector == 1 ? 'las la-check' : 'text-danger las la-times'); ?>"></i></span>
                                            </span>
                                            <p class="mb-0 text-body fs-14 fw-normal">
                                                <?php echo e(localize('AI Detector')); ?></p>
                                        </li>
                                    <?php endif; ?>
                                    <?php if(getSetting('enable_ai_images') != '0' && $package->show_images != 0): ?>
                                        <li class="d-flex align-items-center gap-4">
                                            <span
                                                class="w-6 h-6 flex-shrink-0 <?php echo e($package->allow_images == 1 ? 'bg-success' : 'bg-danger'); ?> bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center">
                                                <span class="text-body fs-12"><i
                                                        class="<?php echo e($package->allow_images == 1 ? 'las la-check' : 'text-danger las la-times'); ?>"></i></span>
                                            </span>
                                            <p class="mb-0 text-body fs-14 fw-normal"><strong class="me-1">
                                                    <?php echo e($package->allow_unlimited_image == 1 ? localize('Unlimited') : $package->total_images_per_month); ?></strong><?php echo e(localize('Images')); ?>

                                            </p>
                                        </li>
                                    <?php endif; ?>
                                    <?php if(getSetting('enable_ai_images') != '0' && $package->show_dall_e_2_image): ?>
                                        <li class="d-flex align-items-center gap-4">
                                            <span
                                                class="w-6 h-6 flex-shrink-0 <?php echo e($package->allow_dall_e_2_image == 1 ? 'bg-success' : 'bg-danger'); ?> bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center">
                                                <span class="text-body fs-12"><i
                                                        class="<?php echo e($package->allow_dall_e_2_image == 1 ? 'las la-check' : 'text-danger las la-times'); ?>"></i></span>
                                            </span>
                                            <p class="mb-0 text-body fs-14 fw-normal"><?php echo e(localize('Dall E 2')); ?>

                                            </p>
                                        </li>
                                    <?php endif; ?>
                                    <?php if(getSetting('enable_ai_images') != '0' && $package->show_dall_e_3_image): ?>
                                        <li class="d-flex align-items-center gap-4">
                                            <span
                                                class="w-6 h-6 flex-shrink-0 <?php echo e($package->allow_dall_e_3_image == 1 ? 'bg-success' : 'bg-danger'); ?> bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center">
                                                <span class="text-body fs-12"><i
                                                        class="<?php echo e($package->allow_dall_e_3_image == 1 ? 'las la-check' : 'text-danger las la-times'); ?>"></i></span>
                                            </span>
                                            <p class="mb-0 text-body fs-14 fw-normal"><?php echo e(localize('Dall E 3')); ?>

                                            </p>
                                        </li>
                                    <?php endif; ?>
                                    <?php if(getSetting('enable_ai_images') != '0' && $package->show_sd_images != 0): ?>
                                    <li class="d-flex align-items-center gap-4">
                                        <span
                                            class="w-6 h-6 flex-shrink-0 <?php echo e($package->show_sd_images == 1 ? 'bg-success' : 'bg-danger'); ?> bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center">
                                            <span class="text-body fs-12"><i
                                                    class="<?php echo e($package->allow_sd_images == 1 ? 'las la-check' : 'text-danger las la-times'); ?>"></i></span>
                                        </span>
                                        <p class="mb-0 text-body fs-14 fw-normal">
                                            <?php echo e(localize('Stable Diffusion Images')); ?></p>
                                    </li>
                                <?php endif; ?>
                                    <?php if(getSetting('enable_ai_chat_image') != '0' && $package->show_ai_image_chat): ?>
                                        <li class="d-flex align-items-center gap-4">
                                            <span
                                                class="w-6 h-6 flex-shrink-0 <?php echo e($package->allow_ai_image_chat == 1 ? 'bg-success' : 'bg-danger'); ?> bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center">
                                                <span class="text-body fs-12"><i
                                                        class="<?php echo e($package->allow_ai_image_chat == 1 ? 'las la-check' : 'text-danger las la-times'); ?>"></i></span>
                                            </span>
                                            <p class="mb-0 text-body fs-14 fw-normal"><?php echo e(localize('AI Image Chat')); ?>

                                            </p>
                                        </li>
                                    <?php endif; ?>
                                    <?php if(getSetting('enable_speech_to_text') != '0' && $package->show_speech_to_text != 0): ?>
                                        <li class="d-flex align-items-center gap-4">
                                            <span
                                                class="w-6 h-6 flex-shrink-0 <?php echo e($package->allow_speech_to_text == 1 ? 'bg-success' : 'bg-danger'); ?> bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center">
                                                <span class="text-body fs-12"><i
                                                        class="<?php echo e($package->allow_speech_to_text == 1 ? 'las la-check' : 'text-danger las la-times'); ?>"></i></span>
                                            </span>
                                            <p class="mb-0 text-body fs-14 fw-normal">
                                                <strong class="me-1">
                                                    <?php echo e($package->allow_unlimited_speech_to_text == 1 ? localize('Unlimited') : $package->total_speech_to_text_per_month); ?></strong><?php echo e(localize('Speech to Text')); ?>

                                            </p>
                                        </li>
                                    <?php endif; ?>
                                    <?php if(getSetting('enable_text_to_speech') != '0' && $package->show_text_to_speech != 0): ?>
                                        <li class="d-flex align-items-center gap-4">
                                            <span
                                                class="w-6 h-6 flex-shrink-0 <?php echo e($package->allow_show_text_to_speech == 1 ? 'bg-success' : 'bg-danger'); ?> bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center">
                                                <span class="text-body fs-12"><i
                                                        class="<?php echo e($package->allow_show_text_to_speech == 1 ? 'las la-check' : 'text-danger las la-times'); ?>"></i></span>
                                            </span>
                                            <p class="mb-0 text-body fs-14 fw-normal">
                                                <strong class="me-1">
                                                    <?php echo e($package->allow_unlimited_text_to_speech == 1 ? localize('Unlimited') : $package->total_text_to_speech_per_month); ?></strong><?php echo e(localize('Text to Speech')); ?>

                                            </p>
                                        </li>
                                    <?php endif; ?>
                                    <?php if($package->show_text_to_speech_open_ai == 1): ?>
                                        <li class="d-flex align-items-center gap-4">
                                            <span
                                                class="w-6 h-6 flex-shrink-0 <?php echo e($package->allow_text_to_speech_open_ai == 1 ? 'bg-success' : 'bg-danger'); ?> bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center">
                                                <span class="text-body fs-12"><i
                                                        class="<?php echo e($package->allow_text_to_speech_open_ai == 1 ? 'las la-check' : 'text-danger las la-times'); ?>"></i></span>
                                            </span>
                                            <p class="mb-0 text-body fs-14 fw-normal">
                                                <?php echo e(localize('Open AI')); ?>

                                            </p>
                                        </li>
                                    <?php endif; ?>
                                    <?php if(getSetting('enable_eleven_labs') != '0' && $package->show_eleven_labs != 0): ?>
                                        <li class="d-flex align-items-center gap-4">
                                            <span
                                                class="w-6 h-6 flex-shrink-0 <?php echo e($package->allow_eleven_labs == 1 ? 'bg-success' : 'bg-danger'); ?> bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center">
                                                <span class="text-body fs-12"><i
                                                        class="<?php echo e($package->allow_eleven_labs == 1 ? 'las la-check' : 'text-danger las la-times'); ?>"></i></span>
                                            </span>
                                            <p class="mb-0 text-body fs-14 fw-normal">
                                                <?php echo e(localize('Eleven Labs')); ?>

                                            </p>
                                        </li>
                                    <?php endif; ?>
                                    <?php if(getSetting('enable_google_cloud') != '0' && $package->show_google_cloud != 0): ?>
                                        <li class="d-flex align-items-center gap-4">
                                            <span
                                                class="w-6 h-6 flex-shrink-0 <?php echo e($package->allow_google_cloud == 1 ? 'bg-success' : 'bg-danger'); ?> bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center">
                                                <span class="text-body fs-12"><i
                                                        class="<?php echo e($package->allow_google_cloud == 1 ? 'las la-check' : 'text-danger las la-times'); ?>"></i></span>
                                            </span>
                                            <p class="mb-0 text-body fs-14 fw-normal">
                                                <?php echo e(localize('Google Cloud')); ?>

                                            </p>
                                        </li>
                                    <?php endif; ?>
                                    <?php if(getSetting('enable_azure') != '0' && $package->show_azure != 0): ?>
                                        <li class="d-flex align-items-center gap-4">
                                            <span
                                                class="w-6 h-6 flex-shrink-0 <?php echo e($package->allow_azure == 1 ? 'bg-success' : 'bg-danger'); ?> bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center">
                                                <span class="text-body fs-12"><i
                                                        class="<?php echo e($package->allow_azure == 1 ? 'las la-check' : 'text-danger las la-times'); ?>"></i></span>
                                            </span>
                                            <p class="mb-0 text-body fs-14 fw-normal">
                                                <?php echo e(localize('Azure')); ?>

                                            </p>
                                        </li>
                                    <?php endif; ?>
                                    <?php if(getSetting('enable_ai_video') != '0' && $package->show_ai_video != 0): ?>
                                        <li class="d-flex align-items-center gap-4">
                                            <span
                                                class="w-6 h-6 flex-shrink-0 <?php echo e($package->allow_ai_video == 1 ? 'bg-success' : 'bg-danger'); ?> bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center">
                                                <span class="text-body fs-12"><i
                                                        class="<?php echo e($package->allow_ai_video == 1 ? 'las la-check' : 'text-danger las la-times'); ?>"></i></span>
                                            </span>
                                            <p class="mb-0 text-body fs-14 fw-normal"> <strong class="me-1">
                                                    <?php echo e($package->allow_unlimited_ai_video == 1 ? localize('Unlimited') : $package->total_ai_video_per_month); ?>

                                                </strong><?php echo e(localize('Image to Video')); ?></p>
                                        </li>
                                    <?php endif; ?>

                                    <?php if($package->show_wordpress == 1): ?>
                                        <li class="d-flex align-items-center gap-4">
                                            <span
                                                class="w-6 h-6 flex-shrink-0 <?php echo e($package->allow_wordpress == 1 ? 'bg-success' : 'bg-danger'); ?> bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center">
                                                <span class="text-body fs-12"><i
                                                        class="<?php echo e($package->allow_wordpress == 1 ? 'las la-check' : 'text-danger las la-times'); ?>"></i></span>
                                            </span>
                                            <p class="mb-0 text-body fs-14 fw-normal">
                                                <?php echo e(localize('Wordpress Posts')); ?>

                                            </p>
                                        </li>
                                    <?php endif; ?>
                                    <?php if($package->show_seo_content_optimization == 1): ?>
                                        <li class="d-flex align-items-center gap-4">
                                            <span
                                                class="w-6 h-6 flex-shrink-0 <?php echo e($package->allow_seo_content_optimization == 1 ? 'bg-success' : 'bg-danger'); ?> bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center">
                                                <span class="text-body fs-12"><i
                                                        class="<?php echo e($package->allow_seo_content_optimization == 1 ? 'las la-check' : 'text-danger las la-times'); ?>"></i></span>
                                            </span>
                                            <p class="mb-0 text-body fs-14 fw-normal">
                                                <?php echo e(localize('SEO Content Optimization')); ?>

                                            </p>
                                        </li>
                                    <?php endif; ?>
                                        
                                    
                                    
                                    <?php if($package->show_total_social_platform_account == 1): ?>
                                        <li class="d-flex align-items-center gap-4">
                                            <span
                                                class="w-6 h-6 flex-shrink-0 bg-success bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center">
                                                <span class="text-body fs-12"><i
                                                        class="las la-check"></i></span>
                                            </span>
                                            <p class="mb-0 text-body fs-14 fw-normal">
                                                <?php echo e($package->total_social_platform_account_per_month ?? 0); ?> <?php echo e(localize('Social Platform Accounts')); ?>

                                            </p>
                                        </li> 
                                    <?php endif; ?>

                                    <?php if($package->show_total_social_platform_post == 1): ?>
                                        <li class="d-flex align-items-center gap-4">
                                            <span
                                                class="w-6 h-6 flex-shrink-0 bg-success bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center">
                                                <span class="text-body fs-12"><i
                                                        class="las la-check"></i></span>
                                            </span>
                                            <p class="mb-0 text-body fs-14 fw-normal">
                                                <?php echo e($package->total_social_platform_post_per_month ?? 0); ?> <?php echo e(localize('Social Platform Posts')); ?>

                                            </p>
                                        </li> 
                                    <?php endif; ?>

                                    <?php if($package->show_facebook_platform == 1 && $package->allow_facebook_platform == 1): ?>
                                        <li class="d-flex align-items-center gap-4">
                                            <span
                                                class="w-6 h-6 flex-shrink-0 bg-success bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center">
                                                <span class="text-body fs-12"><i
                                                        class="las la-check"></i></span>
                                            </span>
                                            <p class="mb-0 text-body fs-14 fw-normal">
                                                <?php echo e(localize('Facebook Platform Access')); ?>

                                            </p>
                                        </li>
                                    <?php endif; ?>

                                    <?php if($package->show_instagram_platform == 1 && $package->allow_instagram_platform == 1): ?>
                                        <li class="d-flex align-items-center gap-4">
                                            <span
                                                class="w-6 h-6 flex-shrink-0 bg-success bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center">
                                                <span class="text-body fs-12"><i
                                                        class="las la-check"></i></span>
                                            </span>
                                            <p class="mb-0 text-body fs-14 fw-normal">
                                                <?php echo e(localize('Instagram Platform Access')); ?>

                                            </p>
                                        </li>
                                    <?php endif; ?>
                                    <?php if($package->show_twitter_platform == 1 && $package->allow_twitter_platform == 1): ?>
                                        <li class="d-flex align-items-center gap-4">
                                            <span
                                                class="w-6 h-6 flex-shrink-0 bg-success bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center">
                                                <span class="text-body fs-12"><i
                                                        class="las la-check"></i></span>
                                            </span>
                                            <p class="mb-0 text-body fs-14 fw-normal">
                                                <?php echo e(localize('Twitter Platform Access')); ?>

                                            </p>
                                        </li>
                                    <?php endif; ?>
                                    <?php if($package->show_linkedin_platform == 1 && $package->allow_linkedin_platform == 1): ?>
                                        <li class="d-flex align-items-center gap-4">
                                            <span
                                                class="w-6 h-6 flex-shrink-0 bg-success bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center">
                                                <span class="text-body fs-12"><i
                                                        class="las la-check"></i></span>
                                            </span>
                                            <p class="mb-0 text-body fs-14 fw-normal">
                                                <?php echo e(localize('LinkedIn Platform Access')); ?>

                                            </p>
                                        </li>
                                    <?php endif; ?>
                                    <?php if($package->show_schedule_posting == 1 && $package->allow_schedule_posting == 1): ?>
                                        <li class="d-flex align-items-center gap-4">
                                            <span
                                                class="w-6 h-6 flex-shrink-0 bg-success bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center">
                                                <span class="text-body fs-12"><i
                                                        class="las la-check"></i></span>
                                            </span>
                                            <p class="mb-0 text-body fs-14 fw-normal">
                                                <?php echo e(localize('Schedule Posting')); ?>

                                            </p>
                                        </li>
                                    <?php endif; ?>
                                    <?php if($package->show_ai_assistant == 1 && $package->allow_ai_assistant == 1): ?>
                                        <li class="d-flex align-items-center gap-4">
                                            <span
                                                class="w-6 h-6 flex-shrink-0 bg-success bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center">
                                                <span class="text-body fs-12"><i
                                                        class="las la-check"></i></span>
                                            </span>
                                            <p class="mb-0 text-body fs-14 fw-normal">
                                                <?php echo e(localize('AI Assistant')); ?>

                                            </p>
                                        </li> 
                                    <?php endif; ?>
                                    

                                    <?php if($package->show_team == 1): ?>
                                        <li class="d-flex align-items-center gap-4">
                                            <span
                                                class="w-6 h-6 flex-shrink-0 <?php echo e($package->allow_team == 1 ? 'bg-success' : 'bg-danger'); ?> bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center">
                                                <span class="text-body fs-12"><i
                                                        class="<?php echo e($package->allow_team == 1 ? 'las la-check' : 'text-danger las la-times'); ?>"></i></span>
                                            </span>
                                            <p class="mb-0 text-body fs-14 fw-normal">
                                                <?php echo e(localize('Team')); ?>

                                            </p>
                                        </li>
                                    <?php endif; ?>

                                    <?php if($package->show_free_support != 0): ?>
                                        <li class="d-flex align-items-center gap-4">
                                            <span
                                                class="w-6 h-6 flex-shrink-0 <?php echo e($package->has_free_support == 1 ? 'bg-success' : 'bg-danger'); ?> bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center">
                                                <span class="text-body fs-12"><i
                                                        class="<?php echo e($package->has_free_support == 1 ? 'las la-check' : 'text-danger las la-times'); ?>"></i></span>
                                            </span>
                                            <p class="mb-0 text-body fs-14 fw-normal">
                                                <?php echo e(localize('Free  Support')); ?></p>
                                        </li>
                                    <?php endif; ?>
                                    <?php
                                        $otherFeatures = explode(',', $package->other_features);
                                    ?>
                                    <?php if($package->other_features): ?>
                                        <?php $__currentLoopData = $otherFeatures; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li class="d-flex align-items-center gap-4">
                                                <span
                                                    class="w-6 h-6 flex-shrink-0 bg-success bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center">
                                                    <span class="text-body fs-12"><i
                                                            class="las la-check"></i></span>
                                                </span>
                                                <p class="mb-0 text-body fs-14 fw-normal"> <?php echo e($feature); ?>

                                                </p>
                                            </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
</section><?php /**PATH /home/u191805559/domains/aitwl.com/public_html/resources/views/frontend/default/pages/partials/pricing.blade.php ENDPATH**/ ?>