<!DOCTYPE html>
<html lang="en" data-bs-theme="light">
<head>
    <!--required meta tags-->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <!--meta-->
    <meta name="description" content="<?php echo $__env->yieldContent('description', 'WriteBot ai content generator and writing assistant for saas platform'); ?>)">
    <meta name="keywords" content="<?php echo $__env->yieldContent('keywords', 'ai, ai assistant, ai content writer, ai copywriting, ai image generator, ai speech to text, ai writer, chat gpt3, chatgpt, content generation, dall-e, openai, openai dalle, openai davinci, Text Generation'); ?>)">
    <meta name="author" content="ThemeTags">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <?php echo $__env->yieldContent('meta'); ?>
    <!--favicon icon-->
    <link rel="icon" href="<?php echo e(avatarImage(getSetting('favicon')) ?? asset('assets/img/favicon.png')); ?>" type="image/png" sizes="16x16">

    <!--title-->
    <title><?php echo $__env->yieldContent('title', config('app.name', 'WriteRap AI')); ?></title>
    <!-- recaptcha -->


    <!-- recaptcha -->
    <?php if(getSetting('enable_google_analytics') == 1): ?>
        <!-- Global site tag (gtag.js) - Google Analytics -->
        <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo e(env('TRACKING_ID')); ?>"></script>

        <script>
            window.dataLayer = window.dataLayer || [];

            function gtag() {
                dataLayer.push(arguments);
            }
            gtag('js', new Date());
            gtag('config', '<?php echo e(env('TRACKING_ID')); ?>');
        </script>
    <?php endif; ?>
    <!--build:css-->
    <?php echo $__env->make('common.css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- endbuild -->
    <?php
        echo getSetting('header_custom_css');
    ?>

    <?php
        echo getSetting('header_custom_scripts');
    ?>

    <?php echo $__env->yieldPushContent('css'); ?>
    <?php echo $__env->yieldContent('styles'); ?>

    <style>
        .swal2-container{
            z-index: 99999999999!important;
        }

        .chatBodyPdfImg{
            height: 50px;
        }
    </style>
    <?php $config = (new \LaravelPWA\Services\ManifestService)->generate(); echo $__env->make( 'laravelpwa::meta' , ['config' => $config])->render(); ?>
</head>

<body>
    <input type="hidden" value="<?php echo e(env('PWA_URL')); ?>" id="PWA_URL">
    <!--preloader start-->
    <?php if(getSetting('enable_preloader') !=0): ?>
        <?php echo $__env->make('common.preloader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>
    <!--preloader end-->
    <?php echo $__env->make('common.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!--main content wrapper start-->
    <main class="tt-main-wrapper bg-content" id="content">
        <?php echo $__env->make('common.media-manager.media-manager', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->make('common.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->make('common.pageTitle', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="container">
            <div class="row">
                <div class="col-12">
                <?php if(session('error')): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <div class="alert-body">
                            <strong><?= session('error') ?> </strong>
                        </div>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>

                <?php if(session('success')): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <div class="alert-body">
                            <strong><?= session('success') ?> </strong>
                        </div>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>
                </div>
            </div>
        </div>

        <?php echo $__env->yieldContent('content'); ?>

        <?php echo $__env->make('common.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <?php echo $__env->make("common.modal.loading-modal", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </main>
    <!--main content wrapper end-->

    <!--build:js-->
    <?php echo $__env->make('common.js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->yieldContent("js"); ?>
    <?php
        echo getSetting('footer_custom_scripts');
    ?>
</body>
</html>
<?php /**PATH /home/u191805559/domains/aitwl.com/public_html/resources/views/layouts/default.blade.php ENDPATH**/ ?>