<!DOCTYPE html>
<html lang="en" data-bs-theme="light">

<head>
    <!--required meta tags-->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!--meta-->
    <meta name="title" content="<?php echo $__env->yieldContent('meta_title', getSetting('global_meta_title')); ?>">
    <meta name="description" content="<?php echo $__env->yieldContent('meta_description', getSetting('global_meta_description')); ?>">
    <meta name="author" content="<?php echo e(getSetting('system_title')); ?>">
    <meta name="keywords" content="<?php echo e(getSetting('global_meta_keywords')); ?>">
    <meta property="og:image" content="<?php echo $__env->yieldContent('meta_image', avatarImage(getSetting('global_meta_image'))); ?>" />

    <!--favicon icon-->
    <link rel="icon" href="<?php echo e(avatarImage(getSetting('favicon')) ?? asset('assets/img/favicon.png')); ?>" type="image/png" sizes="16x16">

    <!--title-->
    <title> <?php echo $__env->yieldContent('title', getSetting('system_title')); ?></title>

    <!--build:css-->
    <?php echo $__env->make('frontend.default.inc.css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- endbuild -->

    <?php   
        echo getSetting('header_custom_css');
    ?>

    <?php
        echo getSetting('header_custom_scripts');
    ?>
    <?php if(getSetting('enable_google_adsense') == 1 && getSetting('adsense_code_snippet')): ?>
        <?php
            echo getSetting('adsense_code_snippet');
        ?>
    <?php endif; ?>
    <?php $config = (new \LaravelPWA\Services\ManifestService)->generate(); echo $__env->make( 'laravelpwa::meta' , ['config' => $config])->render(); ?>

    <?php if(getSetting('enable_google_analytics') == 1): ?>
        <!-- Global site tag (gtag.js) - Google Analytics -->
        <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo e(env('TRACKING_ID')); ?>"></script>

        <script>
            window.dataLayer = window.dataLayer || [];

            function gtag() {
                dataLayer.push(arguments);
            }
            gtag('js', new Date());
            gtag('config', '<?php echo e(env('TRACKING_ID')); ?>');
        </script>
    <?php endif; ?>
</head>

<body class="bg-secondary">

    <?php echo adSense_header_top(); ?>

    <!--preloader start-->
    <?php if(getSetting('enable_preloader') != '0'): ?>

        <?php
            $preLoaderMediaManagerId = getSetting('preloader');
            $mediaFile               = mediaImage($preLoaderMediaManagerId);

            if(empty($mediaFile)){
                $mediaFile = asset('frontend/assets/img/logo-dark.png');
            }
        ?>

        <div class="preloader bg-light-subtle">
            <div class="preloader-wrap">
                <img src="<?php echo e($mediaFile); ?>" alt="logo" class="img-fluid">
                <div class="loading-bar"></div>
            </div>
        </div>
    <?php endif; ?>
    <!--preloader end-->
    
    <!-- Header -->
    <?php echo $__env->make('frontend.default.inc.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- /Header -->
    <?php echo $__env->make('flash::message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldContent('contents'); ?>


    <?php echo $__env->make('frontend.default.inc.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 

    <!--enable_cookie_consent-->
    <?php if(getSetting('enable_cookie_consent') == '1'): ?>
        <div class="cookie-alert">
            <div class="p-3 bg-white rounded shadow-lg">
                <div class="mb-3">
                    <?php echo getSetting('cookie_consent_text'); ?>

                </div>
                <button class="btn btn-primary cookie-accept">
                    <?php echo e(localize('I Understood')); ?>

                </button>
            </div>
        </div>
    <?php endif; ?>

    <?php echo $__env->make('frontend.default.inc.js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    
    <?php echo $__env->yieldContent('js'); ?>
    <?php
        echo getSetting('footer_custom_scripts');
    ?>

</body>
</html><?php /**PATH /home/u191805559/domains/aitwl.com/public_html/resources/views/frontend/default/layouts/default.blade.php ENDPATH**/ ?>