<?php $__env->startSection('title'); ?>
    <?php echo e(localize('Payout Configurations')); ?> <?php echo e(getSetting('title_separator')); ?> <?php echo e(getSetting('system_title')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section class="tt-section pt-4">
        <div class="container">

            <div class="row mb-4">
                <div class="col-12">
                    <div class="tt-page-header">
                        <div class="d-lg-flex align-items-center justify-content-lg-between">
                            <div class="tt-page-title mb-3 mb-lg-0">
                                <h1 class="h4 mb-lg-1"><?php echo e(localize('Payout Configurations')); ?></h1>
                                <ol class="breadcrumb breadcrumb-angle text-muted">
                                    <li class="breadcrumb-item"><a
                                            href="<?php echo e(route('dashboard')); ?>"><?php echo e(localize('Dashboard')); ?></a>
                                    </li>
                                    <li class="breadcrumb-item"><?php echo e(localize('Payouts')); ?></li>
                                </ol>
                            </div>
                            <div class="tt-action">

                            </div>
                        </div>
                    </div>
                </div>
            </div>


            
            <div class="row g-3 mb-4">
                <div class="col-lg-3 col-md-6">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="avatar me-2 flex-shrink-0">
                                    <div class="text-center rounded bg-soft-warning">
                                        <span><i data-feather="dollar-sign"></i></span>
                                    </div>
                                </div>
                                <div class="flex-grow-1">
                                    <p class="mb-0"><?php echo e(localize('Available Balance')); ?></p>
                                    <h4 class="mb-0"><?php echo e(formatPrice($user->user_balance, true)); ?></h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="avatar me-2 flex-shrink-0">
                                    <div class="text-center rounded bg-soft-primary">
                                        <span><i data-feather="credit-card"></i></span>
                                    </div>
                                </div>
                                <div class="flex-grow-1">
                                    <p class="mb-0"><?php echo e(localize('Total Subscriptions')); ?></p>
                                    <h4 class="mb-0"><?php echo e($user->referredUserEarnings()->count()); ?></h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="avatar me-2 flex-shrink-0">
                                    <div class="text-center rounded bg-soft-danger">
                                        <span><i data-feather="link"></i></span>
                                    </div>
                                </div>
                                <div class="flex-grow-1">
                                    <p class="mb-0"><?php echo e(localize('Total Clicks')); ?></p>
                                    <h4 class="mb-0"><?php echo e($user->num_of_clicks); ?></h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-3 col-md-6">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="avatar me-2 flex-shrink-0">
                                    <div class="text-center rounded bg-soft-info">
                                        <span><i data-feather="dollar-sign"></i></span>
                                    </div>
                                </div>
                                <div class="flex-grow-1">
                                    <p class="mb-0"><?php echo e(localize('Referral Signups')); ?></p>
                                    <h4 class="mb-0"><?php echo e($user->referredUsers()->count()); ?></h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            


            <div class="row mb-4">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="mb-3"><?php echo e(localize('Configure Payout Accounts')); ?></h5>
                          

                            <div class="row">
                                <form action="<?php echo e(route('admin.affiliate.payout.configureStore')); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <!--general settings-->
                                    <div class="card mb-4" id="section-1">
                                        <div class="card-body">

                                            <?php if(in_array('bank_payment', $activeAffiliatePaymentMethods)): ?>
                                                <?php
                                                    $paymentDetails = \App\Models\AffiliatePayoutAccount::where('user_id', $user->id)
                                                        ->where('payment_method', 'bank_payment')
                                                        ->first();
                                                ?>
                                                <div class="mb-3">
                                                    <label for="affiliate_commission" class="form-label">
                                                        <?php echo e(localize('Bank Details')); ?>

                                                    </label>
                                                    <div class="input-group mb-3">
                                                        <input type="text" id="bank_payment" name="bank_payment"
                                                            class="form-control"
                                                            placeholder="<?php echo e(localize('Type bank payment details')); ?>"
                                                            value="<?php echo e($paymentDetails != null ? $paymentDetails->account_details : ''); ?>">
                                                    </div>
                                                </div>
                                            <?php endif; ?>


                                            <?php if(in_array('paypal', $activeAffiliatePaymentMethods)): ?>
                                                <?php
                                                    $paymentDetails = \App\Models\AffiliatePayoutAccount::where('user_id', $user->id)
                                                        ->where('payment_method', 'paypal')
                                                        ->first();
                                                ?>
                                                <div class="mb-3">
                                                    <label for="affiliate_commission" class="form-label">
                                                        <?php echo e(localize('Paypal Details')); ?>

                                                    </label>
                                                    <div class="input-group mb-3">
                                                        <input type="text" id="paypal" name="paypal"
                                                            class="form-control"
                                                            placeholder="<?php echo e(localize('Type paypal payment details')); ?>"
                                                            value="<?php echo e($paymentDetails != null ? $paymentDetails->account_details : ''); ?>">
                                                    </div>
                                                </div>
                                            <?php endif; ?>


                                            <?php if(in_array('stripe', $activeAffiliatePaymentMethods)): ?>
                                                <?php
                                                    $paymentDetails = \App\Models\AffiliatePayoutAccount::where('user_id', $user->id)
                                                        ->where('payment_method', 'stripe')
                                                        ->first();
                                                ?>
                                                <div class="mb-3">
                                                    <label for="affiliate_commission" class="form-label">
                                                        <?php echo e(localize('Stripe Details')); ?>

                                                    </label>
                                                    <div class="input-group mb-3">
                                                        <input type="text" id="stripe" name="stripe"
                                                            class="form-control"
                                                            placeholder="<?php echo e(localize('Type stripe payment details')); ?>"
                                                            value="<?php echo e($paymentDetails != null ? $paymentDetails->account_details : ''); ?>">
                                                    </div>
                                                </div>
                                            <?php endif; ?>


                                            <?php if(in_array('paytm', $activeAffiliatePaymentMethods)): ?>
                                                <?php
                                                    $paymentDetails = \App\Models\AffiliatePayoutAccount::where('user_id', $user->id)
                                                        ->where('payment_method', 'paytm')
                                                        ->first();
                                                ?>
                                                <div class="mb-3">
                                                    <label for="affiliate_commission" class="form-label">
                                                        <?php echo e(localize('PayTm Details')); ?>

                                                    </label>
                                                    <div class="input-group mb-3">
                                                        <input type="text" id="paytm" name="paytm"
                                                            class="form-control"
                                                            placeholder="<?php echo e(localize('Type paytm payment details')); ?>"
                                                            value="<?php echo e($paymentDetails != null ? $paymentDetails->account_details : ''); ?>">
                                                    </div>
                                                </div>
                                            <?php endif; ?>

                                            <?php if(in_array('razorpay', $activeAffiliatePaymentMethods)): ?>
                                                <?php
                                                    $paymentDetails = \App\Models\AffiliatePayoutAccount::where('user_id', $user->id)
                                                        ->where('payment_method', 'razorpay')
                                                        ->first();
                                                ?>
                                                <div class="mb-3">
                                                    <label for="affiliate_commission" class="form-label">
                                                        <?php echo e(localize('Razorpay Details')); ?>

                                                    </label>
                                                    <div class="input-group mb-3">
                                                        <input type="text" id="razorpay" name="razorpay"
                                                            class="form-control"
                                                            placeholder="<?php echo e(localize('Type razorpay payment details')); ?>"
                                                            value="<?php echo e($paymentDetails != null ? $paymentDetails->account_details : ''); ?>">
                                                    </div>
                                                </div>
                                            <?php endif; ?>

                                            <?php if(in_array('iyzico', $activeAffiliatePaymentMethods)): ?>
                                                <?php
                                                    $paymentDetails = \App\Models\AffiliatePayoutAccount::where('user_id', $user->id)
                                                        ->where('payment_method', 'iyzico')
                                                        ->first();
                                                ?>
                                                <div class="mb-3">
                                                    <label for="affiliate_commission" class="form-label">
                                                        <?php echo e(localize('IyZico Details')); ?>

                                                    </label>
                                                    <div class="input-group mb-3">
                                                        <input type="text" id="iyzico" name="iyzico"
                                                            class="form-control"
                                                            placeholder="<?php echo e(localize('Type iyzico payment details')); ?>"
                                                            value="<?php echo e($paymentDetails != null ? $paymentDetails->account_details : ''); ?>">
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <!--general settings-->

                                    <div class="mb-3">
                                        <button class="btn btn-primary" type="submit">
                                            <i data-feather="save" class="me-1"></i>
                                            <?php echo e(localize('Save Configuration')); ?>

                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('modals'); ?>
    <div id="withdraw-modal" class="modal fade">
        <div class="modal-dialog modal-md modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo e(localize('Withdraw Money')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-hidden="true"></button>
                </div>
                <div class="modal-body text-center">

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        "use strict";

        function copyToClipboard(btn) {
            var el_url = document.getElementById('referral_code_url');
            var c_u_b = document.getElementById('ref-cpurl-btn');
            if (el_url != null && c_u_b != null) {
                el_url.select();
                document.execCommand('copy');
                c_u_b.innerHTML = c_u_b.dataset.attrcpy;
            }
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u191805559/domains/aitwl.com/public_html/resources/views/backend/admin/affiliate/configurePayouts.blade.php ENDPATH**/ ?>