
<div class="modal fade" id="packagePaymentModal" tabindex="-1" aria-labelledby="packagePaymentModalLabel"
     aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="packagePaymentModalLabel"><?php echo e(localize('Select Payment Method')); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body p-4">

                <form action="<?php echo e(route('website.subscriptions.subscribe')); ?>" method="POST" class="payment-method-form" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="package_id" value="" class="payment_package_id">
                    <!-- Online payment gateway -->
                    <?php if(auth()->guard()->check()): ?>
                        <div class="row g-3">

                            <div class="col-md-12 mb-3">
                                <div class="form-check tt-checkbox">
                                    <?php echo e(localize('Your current active package will be expired and This Will be active.')); ?>

                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                    <div class="online_payment" id="online_payment">
                        <div class="row g-3">
                            <?php if(count($payments) > 0): ?>
                                <?php $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-lg-3 col-md-6">
                                        <div class="tt-single-gateway text-center">
                                            <input type="radio" class="tt-custom-radio" name="payment_method"
                                                   id="<?php echo e($method->gateway); ?>" value="<?php echo e($method->id); ?>" required>
                                            <label class="tt-gateway-info card p-3 cursor-pointer flex-column h-100 <?php echo e($method->gateway == appStatic()::OFFLINE_PAYMENT_METHOD ? 'oflinePayment' : ''); ?>"
                                                   for="<?php echo e($method->gateway); ?>"  data-method="<?php echo e($method->gateway); ?>">
                                                <div class="tt-gateway-icon">
                                                    <img src="<?php echo e(asset($method->image)); ?>"
                                                         alt="<?php echo e(strtoupper($method->gateway)); ?>" class="img-fluid">
                                                </div>
                                            </label>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </div>
                        <button type="submit"
                                class="btn btn-primary mt-4 px-5"><?php echo e(localize('Proceed')); ?></button>
                    </div>

                    <!--payment -->
                    <?php echo $__env->make('frontend.common._offline_payment', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </form>
            </div>
        </div>
    </div>
</div><?php /**PATH /home/u191805559/domains/aitwl.com/public_html/resources/views/common/modal/package-payment-modal.blade.php ENDPATH**/ ?>