    <!-- Header -->
    <div class="navbar-overlay">
        <nav class="navbar navbar-1 navbar-expand-lg">
            <div class="container">
                <a class="navbar-brand logo" href="<?php echo e(route('layouts')); ?>">
                    <img src="<?php echo e(getSetting('logo_for_light') ? avatarImage(getSetting('logo_for_light')) : asset('frontend/assets/img/logo-light.png')); ?>"
                        alt="image" class="logo__img">
                    <img src="<?php echo e(getSetting('logo_for_dark') ? avatarImage(getSetting('logo_for_dark')) : asset('frontend/assets/img/logo-dark.png')); ?>"
                        alt="image" class="logo__img logo__sticky">
                </a>
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#primaryMenu"
                    aria-expanded="false">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <div class="collapse navbar-collapse" id="primaryMenu">
                  
                    <ul class="navbar-nav align-items-lg-center gap-lg-3 mx-auto text-body">
                        <li class="nav-item">
                            <a class="nav-link active" href="<?php echo e(route('layouts')); ?>"><?php echo e(localize('Home')); ?></a>
                        </li>

                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo e(route('about-us')); ?>"><?php echo e(localize('About Us')); ?></a>
                        </li>

                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo e(route("pricing")); ?>"><?php echo e(localize('Pricing')); ?></a>
                        </li>

                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo e(route('contact-us')); ?>"><?php echo e(localize('Contact Us')); ?></a>
                        </li>

                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo e(route('blogs')); ?>"><?php echo e(localize('Blogs')); ?></a>
                        </li>                     
                       
                        <?php if (isset($component)) { $__componentOriginal5c551322cf21afaec98647ff836d5faa = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal5c551322cf21afaec98647ff836d5faa = $attributes; } ?>
<?php $component = App\View\Components\HeaderPage::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('header-page'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\HeaderPage::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal5c551322cf21afaec98647ff836d5faa)): ?>
<?php $attributes = $__attributesOriginal5c551322cf21afaec98647ff836d5faa; ?>
<?php unset($__attributesOriginal5c551322cf21afaec98647ff836d5faa); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal5c551322cf21afaec98647ff836d5faa)): ?>
<?php $component = $__componentOriginal5c551322cf21afaec98647ff836d5faa; ?>
<?php unset($__componentOriginal5c551322cf21afaec98647ff836d5faa); ?>
<?php endif; ?>
                    </ul>

                    <div class="d-flex align-items-center gap-3 flex-wrap">
                        <div class="d-flex align-items-center gap-2">
                            <div class="d-flex align-items-center gap-1">
                                <img src="<?php echo e(asset('assets/img/flags/'.currentLanguage()->code.'.png')); ?>" alt="flag" class="img-fluid">
                                <select name="language" id="language" class="bg-dark text-body fs-14 border-0 changeLocaleLanguage">
                                    <?php $__currentLoopData = languages(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($language->code); ?>" <?php echo e(currentLanguage()->code == $language->code ? 'selected':''); ?>><?php echo e($language->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </select>
                            </div>
                            <select name="country" id="country" class="bg-dark text-body fs-14 border-0 changeLocaleCurrency">
                                <?php $__currentLoopData = currencies(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($currency->code); ?>" <?php echo e($currency->code == currentCurrency()->code ?'selected':''); ?>> <?php echo e($currency->symbol); ?>

                                        <?php echo e(strtoupper($currency->code)); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </select>
                        </div>
                        <?php if(!auth()->check()): ?>
                            <a href="<?php echo e(route('register')); ?>" 
                                class="nav-link fs-14 rounded-1">
                                <?php echo e(localize('Sign up')); ?>

                            </a>
                        <?php endif; ?>
                        <a href="<?php echo e(auth()->check() ? route('dashboard') : route('login')); ?>"
                            class="btn btn-lg btn-outline-light px-4 py-2 fs-14 rounded-pill border-primary btn-svg-hover d-flex align-items-center gap-2 fs-14 text-heading">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <rect x="-0.00732422" width="24" height="24" rx="12" fill="url(#paint0_linear_1780_21102)"/>
                                <path d="M6.43178 11.6523C6.43178 11.6523 12.4408 11.6523 17.8604 11.6523M17.8604 11.6523C13.9453 11.6523 13.2227 7.65234 13.2227 7.65234M17.8604 11.6523C13.9453 11.6523 13.2227 15.6523 13.2227 15.6523" stroke="white" stroke-width="1.1"/>
                                <defs>
                                <linearGradient id="paint0_linear_1780_21102" x1="-0.00732422" y1="12" x2="23.9927" y2="12" gradientUnits="userSpaceOnUse">
                                <stop stop-color="#805AF9"/>
                                <stop offset="1" stop-color="#6632F8"/>
                                </linearGradient>
                                </defs>
                            </svg>
                            <?php echo e(auth()->check() ? localize('Dashboard') : localize('Start for free')); ?>

                        </a>
                    </div>
                </div>
            </div>
        </nav>
    </div><!-- /Header -->
<?php /**PATH /home/u191805559/domains/aitwl.com/public_html/resources/views/frontend/default/inc/header.blade.php ENDPATH**/ ?>