<?php $__env->startSection('title'); ?>
    <?php echo e(localize('Register')); ?> <?php echo e(getSetting('tab_separator')); ?> <?php echo e(getSetting('system_title')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <?php
        $authImage = getSetting("auth_image");
        $darkLogo  = getSetting("logo_for_dark");
        $finalLogo = $darkLogo;

        if(empty($darkLogo)){
            $finalLogo = getSetting("logo_for_light");
        }

        if(empty($finalLogo)){
            $finalLogo = asset('assets/img/logo-color.png');
        }
    ?>

    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="tt-form-container bg-light p-4 d-flex shadow-sm rounded-4 my-4 my-lg-0">
                    <div class="tt-from-img rounded-2 me-md-4 d-none d-md-block"
                         style="background: url(<?php echo e(avatarImage($authImage) ?? asset('/assets/img/login-img.jpg')); ?>)no-repeat center center / cover">
                    </div>

                    <!-- login form wrap start -->
                    <div class="tt-form-content p-lg-4 py-lg-5 py-5">
                        <!-- login head info start -->

                        <div class="mb-6">
                            <a href="<?php echo e(route('layouts')); ?>" class="navbar-brand d-block mb-4 text-decoration-none">
                                <?php if(!empty($finalLogo)): ?>
                                    <img src="<?php echo e(avatarImage($finalLogo)); ?>"
                                         alt="logo"
                                         class="img-fluid logo-color"
                                    />
                                <?php else: ?>
                                    <img src="<?php echo e(asset('assets/img/logo-color.png')); ?>"
                                         alt="logo"
                                         class="img-fluid logo-color"
                                    />
                                <?php endif; ?>
                            </a>

                            <h2 class="h4 fw-bold"><?php echo e(localize('Welcome Back')); ?></h2>
                            <p class="text-muted"><?php echo e(localize('Sign in to your account to continue')); ?></p>
                        </div>
                        <!-- login head info end -->

                        <!-- registration form start -->
                        <form action="<?php echo e(route('register')); ?>" method="POST" class="tt-login-register-form">
                            <?php echo csrf_field(); ?>
                            <?php if(getSetting('enable_recaptcha') == 1): ?>
                                <?php echo RecaptchaV3::field('recaptcha_token'); ?>

                            <?php endif; ?>
                            <div class="row">
                                <div class="col-sm-12">
                                    <label for="name" class="form-label"><?php echo e(localize('Name')); ?> <span
                                            class="text-danger">*</span></label>
                                    <div class="input-group mb-3">
                                        <input id="name" type="text"
                                            class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="name"
                                            value="<?php echo e(old('name')); ?>" placeholder="<?php echo e(localize('Name')); ?>"
                                            aria-label="<?php echo e(localize('Name')); ?>">
                                        <?php echo e(errorBlock('name')); ?>

                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <label for="email" class="form-label"><?php echo e(localize('Email')); ?> <span
                                            class="text-danger">*</span></label>
                                    <div class="input-group mb-3">
                                        <input id="email" type="email"
                                            class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="email"
                                            value="<?php echo e(old('email')); ?>" placeholder="<?php echo e(localize('Email')); ?>"
                                            aria-label="<?php echo e(localize('Email')); ?>">
                                        <?php echo e(errorBlock('email')); ?>

                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <label for="mobile_no" class="form-label"><?php echo e(localize('Mobile')); ?> 
                                    <?php if(getSetting('registration_with') == 'email_and_phone'): ?>
                                        <span class="text-danger">*</span>
                                    <?php endif; ?>
                                    </label>
                                    <div class="input-group mb-3">
                                        <input id="mobile_no" type="text"
                                            class="form-control <?php $__errorArgs = ['mobile_no'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="mobile_no"
                                            value="<?php echo e(old('mobile_no')); ?>" placeholder="012345678"
                                            aria-label="012345678">
                                        <?php echo e(errorBlock('mobile_no')); ?>

                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <label for="password" class="form-label"><?php echo e(localize('Password')); ?> <span
                                            class="text-danger">*</span></label>
                                    <div class="input-group tt-check-password mb-3">
                                        <input id="password" type="password"
                                            class="form-control rounded-end <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            name="password" placeholder="<?php echo e(localize('Password')); ?>"
                                            aria-label="<?php echo e(localize('Password')); ?>" autocomplete="current-password">
                                        <span class="tt-eye-check eye-icon"><i data-feather="eye"></i></span>
                                        <span class="tt-eye-check eye-icon-off"><i data-feather="eye-off"></i></span>
                                    </div>
                                    <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    <div class="form-check">
                                        <input class="form-check-input" name="i_agree" type="checkbox" id="ex-check-1">
                                        <label class="form-check-label"
                                            for="ex-check-1"><?php echo e(localize('I agree with the')); ?> <a
                                                href="<?php echo e(route('terms-conditions')); ?>" target="_blank"><?php echo e(localize('Terms of Service')); ?></a>,
                                            <a
                                                href="<?php echo e(route('privacy-policy')); ?>" target="_blank"><?php echo e(localize('Privacy Policy')); ?></a><?php echo e(localize(', and default')); ?>

                                            .</label>
                                            </div>
                                            <?php echo e(errorBlock('i_agree')); ?>

                                </div>

                                <div class="col-12">
                                    <button type="submit"
                                        class="btn btn-primary mt-3 d-block w-100"><?php echo e(localize('Sign Up')); ?></button>
                                </div>
                            </div>
                            <p class="mt-3 text-center"><?php echo e(localize('Already have an account?')); ?> <a
                                    href="<?php echo e(route('login')); ?>" class="fw-medium"><?php echo e(localize('Sign In')); ?></a>
                            </p>
                        </form>
                        <!-- registration form end -->
                        <?php if(getSetting('google_login') == 1 || getSetting('facebook_login') == 1): ?>
                        <div class="tt-or-divider">
                            <?php echo e(localize('Or')); ?>

                        </div>
                   
                        <!-- social login start -->
                        <div class="d-flex justify-content-center gap-3 mt-4">
                            <?php if(getSetting('google_login') == 1): ?>
                                <a href="<?php echo e(route('social.login', ['provider' => 'google'])); ?>"
                                    class="btn btn-light btn-icon rounded-circle text-center border btn-shadow d-flex p-2">
                                    <img src="<?php echo e(asset('assets/img/website/google-icon.svg')); ?>" alt="google">
                            <?php endif; ?>
                            <?php if(getSetting('facebook_login') == 1): ?>
                                </a><a href="<?php echo e(route('social.login', ['provider' => 'facebook'])); ?>"
                                    class="btn btn-light btn-icon rounded-circle text-center border btn-shadow d-flex p-2">
                                    <img src="<?php echo e(asset('assets/img/website/facebook-icon.svg')); ?>" alt="google">
                                </a>
                            <?php endif; ?>
                        </div>
                        <?php endif; ?>

                        <!-- social login end -->
                    </div>
                    <!-- login form wrap end -->

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.login', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u191805559/domains/aitwl.com/public_html/resources/views/auth/register.blade.php ENDPATH**/ ?>