<?php

namespace Modules\ExternalAiChat\App\Http\Requests;

use App\Traits\Api\ApiResponseTrait;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;

class ChatBotRequest extends FormRequest
{
    use ApiResponseTrait;
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array {
        return [
            'bot_name'        => 'required|string|max:255',
            'bubble_message'  => 'required|string|max:255',
            'welcome_message' => 'required|string|max:255',
            'instructions'    => 'nullable|string',
            'color_code'      => 'required|string|max:255',
            'avatar'          => 'string|nullable',
            'is_active'       => 'numeric',
        ];
    }

    public function messages() {
        return [
            'bot_name.required' => 'The chatbot name field is required.',
            'bot_name.string'   => 'The chatbot name field must be a string.',
            'bot_name.max'      => 'The chatbot name field must not exceed 255 characters.',

            'bubble_message.required' => 'The bubble message field is required.',
            'bubble_message.string'   => 'The bubble message field must be a string.',
            'bubble_message.max'      => 'The bubble message field must not exceed 255 characters.',

            'welcome_message.required' => 'The welcome message field is required.',
            'welcome_message.string'   => 'The welcome message field must be a string.',
            'welcome_message.max'      => 'The welcome message field must not exceed 255 characters.',
            
            'instructions.string' => 'The instructions field must be a string.',
            
            'color_code.required' => 'The color field is required.',
            'color_code.string'   => 'The color field must be a string.',
            'color_code.max'      => 'The color field must not exceed 255 characters.',
        ];
    }

    protected function failedValidation(Validator $validator) {
        throw new HttpResponseException($this->sendResponse(appStatic()::VALIDATION_ERROR, localize("There are errors in the form."), [], $validator->errors()));
    }

    public function getValidatedData($id = 0) {
        $data              = $this->validated();
        $data["is_active"] = setActiveStatus();

        unset($data['id']);

        return $data;
    }
}
