<?php

namespace Modules\ExternalAiChat\App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;

class ChatBotThread extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $fillable = [
        "user_id",
        "title",

        "prompts_words",
        "completion_words",
        "total_words",
        "prompts_token",
        "completion_token",
        "total_token",
        
        "chat_bot_id",
    ];

    public function chatBot()
    {
        return $this->belongsTo(ChatBot::class, "chat_bot_id");
    }

    public function chats($limit = null)
    {
        if($limit){
            return $this->hasMany(ChatBotThreadMessage::class, "chat_bot_thread_id")
                    ->latest("id")
                    ->limit($limit);
        }

        return $this->hasMany(ChatBotThreadMessage::class, "chat_bot_thread_id")->oldest("id");
    }

    public function scopeChatBotId($query, $chat_bot_id)
    {
        $query->where("chat_bot_id", $chat_bot_id);
    }

    public function scopeType($query, $type = "chat", $isLike = false)
    {
        if($isLike){
            $query->where("type", "like", "%$type%");
        }
        else{
            $query->where("type", $type);
        }
    }

    public function scopeFilters($query)
    {
        $request = request();

        // Chat Bot ID
          if($request->has("chat_bot_id") && !empty($request->chat_bot_id)){
            $query->where("chat_bot_id",(int)$request->chat_bot_id);
        }

        //Search
        if($request->has("search")){
            $query->where("search",$request->search);
        }
      
        // Type
        if($request->has("type")){
            $query->type($request->type);
        }

        // chat_bot_thread_id
        if($request->has("chat_bot_thread_id") && !empty($request->chat_bot_thread_id)){
            $query->where("id", $request->chat_bot_thread_id);
        }
    }
}
