<?php

namespace Modules\ExternalAiChat\App\Services;

use Illuminate\Database\Eloquent\Model;
use Modules\ExternalAiChat\App\Models\ChatBot;
use Modules\ExternalAiChat\App\Models\ChatBotThread;
use Modules\ExternalAiChat\App\Models\ChatBotThreadMessage;

/**
 * Class ChatBotService.
 */
class ChatBotService
{
    public function all() {
        $request  = request();
        $search   = $request->search;

        $query = ChatBot::where('user_id', getAdminOrCustomerId())->filters();

        return $query->latest()->paginate(request('perPage', appStatic()::PER_PAGE_DEFAULT), "*", "page", request('page', 0))->withQueryString();
    }

    public function getAll(
        $isPaginateOrGet = false,
        $isActiveOnly = null,
        $type = null
    )
    {
        $query = ChatBot::query()->when($type, function($q) use ($type){
            $q->where('type', $type);
        });

        // when is Paginate or Get contain null
        if(is_null($isPaginateOrGet)) {
            return  $query->pluck("expert_name", "id");
        }

        if(!is_null($isActiveOnly)) {
            $query->isActive($isActiveOnly);
        }


        return $isPaginateOrGet ? $query->paginate(maxPaginateNo()) : $query->get();
    }

    /**
     * Expert Store
     * */
    public function store($payloads) : Model {
        return ChatBot::query()->create($payloads);
    }

    /**
     * Expert Update
     * */
    public function update($chatBot, $payloads) : Model {
        $chatBot->update($payloads);
        return $chatBot;
    }

    /**
     * Expert info
     * */
    public function getChatBotById($id, $isFirstOnly = true) {
        $query =  ChatBot::query();
        return $isFirstOnly ? $query->find($id) : $query->findOrFail($id);
    }
    
    # chatbot by uuid
    public function getChatBotByUUID($uuid) { 
        return ChatBot::whereUuid($uuid)->first();
    }
    
    # chatbot threads
    public function getOrCreateChatBotThreads($chatbot) {
        $threads = $chatbot->threads;
        if(count($threads) <= 0){
            $this->createChatbotThread($chatbot);
            $threads = $chatbot->threads()->get();
        }
        return $threads;
    }

    # create new thread
    public function createChatbotThread($chatbot) { 
        $chatbotThread = ChatBotThread::create([
            'chat_bot_id' => $chatbot->id,
            'user_id'     => setAndGetChatbotVisitorId(),
        ]);
        $this->createChatbotThreadMessage($chatbotThread, $chatbot->welcome_message); // initial welcome message by assistant
    }

    # get chatbot thread by id
    public function getChatBotThreadById($id) {
        return ChatBotThread::findOrFail((int)$id);
    }

    # create new thread message
    public function createChatbotThreadMessage($chatbotThread, $response = null, $prompt = null) { 
        $data = [ 
            'chat_bot_id'        => $chatbotThread->chat_bot_id,
            'chat_bot_thread_id' => $chatbotThread->id,
        ];
        if($response){
            $data['response'] = $response;
        }else{
            $data['prompt'] = $prompt;
        }
        $chatbotThreadMessage = ChatBotThreadMessage::create($data);
        return $chatbotThreadMessage;
    }
    
    # getChatBotThreadMessages
    public function getChatBotThreadMessages($id) { 
        return ChatBotThreadMessage::where('chat_bot_thread_id', $id)->oldest()->get();
    }
}
