<style>
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }

    .text-center{
        text-align:center;
    }
    body {
        font-family: sans-serif;
        margin-bottom: 0 !important;
    }

    .chat-container {
        background-color: #fff;
    }

    .chat_list_btn_wrapper {
        display: flex;
        flex-direction: column;
        justify-content: space-between;
        gap: 20px;
        height: 90vh;
    }

    .chat-header {
        background-color: {{ $chatbot->color_code }};
        color: black;
        padding: 16px;
        font-weight: bold;
        font-size: 18px;
    }

    .chat-list {
        list-style: none;
        padding: 0;
        margin: 0;
        overflow: auto;
    }

    .chat-item {
        display: flex;
        align-items: flex-start;
        padding: 12px 16px;
        border-bottom: 1px solid #eee;
    }

    .chat-item:last-child {
        border-bottom: none;
    }

    .chat-avatar {
        width: 36px;
        height: 36px;
        border-radius: 50%;
        margin-right: 12px;
    }

    .chat-content {
        flex: 1;
    }

    .chat-name {
        font-weight: bold;
        font-size: 14px;
        margin-bottom: 4px;
    }

    .chat-text {
        font-size: 13px;
        color: #333;
    }

    .chat-time {
        font-size: 11px;
        color: gray;
        text-align: right;
    }

    .new-chat {
        padding: 14px 16px;
        text-align: center;
        background-color: #f9f9f9;
        border-top: 1px solid #eee;
        font-size: 14px;
        color: black;
        cursor: pointer;
    }

    .new-chat:hover {
    background-color: #f0f0f0;
    }

    .chat-wrapper {
        height: 62vh;
        display: flex;
        flex-direction: column;
        border: 1px solid #ddd;
        background: #fff;
        display: none;
    }

    .chat-box {
        flex: 1;
        padding: 20px;
        overflow-y: auto;
    }

    .message {
        display: flex;
        align-items: flex-start;
        margin-bottom: 16px;
    }

    .message.user {
        flex-direction: row-reverse;
    }

    .avatar {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        margin: 0 10px;
    }

    .bubble {
        max-width: 75%;
        padding: 14px 18px;
        border-radius: 16px;
        font-size: 14px;
        line-height: 1.5;
    }

    .bot .bubble {
        background: #f0f4ff;
        border-top-left-radius: 0;
    }

    .user .bubble {
        background: {{ $chatbot->color_code }};
        border: 1px solid #ddd;
        border-top-right-radius: 0;
    }

    /* Input Area */
    .chat-input-area {
        display: flex;
        padding: 16px;
        border-top: 1px solid #ddd;
        background: #fafafa;
        flex-wrap: wrap;
        gap: 10px;
    }

    .chat-input-area input {
        flex: 1;
        padding: 10px 16px;
        border-radius: 20px;
        border: 1px solid #ccc;
        outline: none;
        font-size: 14px;
    }

    .chat-input-area button {
        margin-left: 10px;
        padding: 10px 20px;
        border: none;
        border-radius: 20px;
        cursor: pointer;
        font-size: 14px;
    }

    .send-btn {
        background: {{ $chatbot->color_code }};
        color: black;
    }

    .stop-btn {
        background: #f1f1f1;
        color: black;
    }

    .send-btn:hover {
        background: {{ $chatbot->color_code }};
    }

    .stop-btn:hover {
        background: #e1e1e1;
    }

    .back_btn {
        margin-right: 8px;
    }

    @media (max-width: 575px) {
        .chat-input-area input {
            width: 70px;
        }
        .chat-input-area button {
            padding: 5px 10px;
            margin-left: 0;
        }
        .back_btn {
            margin-right: 0;
        }
    }
</style>