@php
    setAndGetChatbotVisitorId();
@endphp

<script>
    // load chat list & messages
    function getDataList() {
        
        loading('#chatBox');
        loading('.chat-list');
        var callParams      = {};
        callParams.type     = "GET";
        // callParams.dataType = "html";
        callParams.url      = "{{ route('chatbot.threads', $chatbot->uuid) }}";
        callParams.data     = '';
        ajaxCall(callParams, function (result) {
            $('.chat-list').empty().html(result.chatbotThreads);
            handleChatClick();

            if(result.chatbotThreadsCount < 2){
                hideChatList();
                showChatMessages(); 
                $('#chatBox').empty().html(result.firstThreadMessages); 
            }else{
                hideChatMessages();
                showChatList();
            }
            
        }, function onErrorData(err, type, httpStatus) {});
    }
    
    getDataList();

    function getChatThreadMessages(id) {
        loading('#chatBox');

        // Hide chat-list
        document.querySelector('.chat-list').style.display = 'none';
        document.querySelector('.new-chat').style.display = 'none';
        // Show chat-wrapper
        document.querySelector('.chat-wrapper').style.display = 'flex';
        document.querySelector('.chat-wrapper').style.height = '90vh';

        var callParams      = {};
        callParams.type     = "GET";
        callParams.dataType = "html";
        callParams.url      = "{{ route('chatbot.threadMessages') }}" + `/${id}`;
        callParams.data     = '';
        ajaxCall(callParams, function (result) {
            $('#chatBox').empty().html(result); 
            initScrollToChatBottomThisPage();
        }, function onErrorData(err, type, httpStatus) {});
    }

    function hideChatList() {
        // Hide chat-list
        document.querySelector('.chat-list').style.display = 'none';
        document.querySelector('.new-chat').style.display = 'none';
    }
    
    function showChatMessages() {
        // Show chat-wrapper
        document.querySelector('.chat-wrapper').style.display = 'flex';
        document.querySelector('.chat-wrapper').style.height = '90vh';
    }
    
    function showChatList() {
        // Show chat-wrapper
        document.querySelector('.chat-list').style.display = 'block';
        document.querySelector('.new-chat').style.display = 'block';
    }

    function hideChatMessages() {
        // Show chat-wrapper
        document.querySelector('.chat-wrapper').style.display = 'none';
    }

    function handleChatClick() {
        const chatItems = document.querySelectorAll('.chat-item');
    
        // Add click event to each chat item
        chatItems.forEach(item => {
            item.addEventListener('click', function() {
                let chatThreadId = $(this).data('id');
                getChatThreadMessages(chatThreadId); 
            });
        });

        const backBtn = document.querySelector('.back_btn');
    
        // Add click event to back button
        if (backBtn) {
            backBtn.addEventListener('click', function() {
                // Show chat-list
                document.querySelector('.chat-list').style.display = 'block';
                document.querySelector('.new-chat').style.display = 'block';
                // Hide chat-wrapper
                document.querySelector('.chat-wrapper').style.display = 'none';
            });
        }
    }

    $(document).on('keydown', '.prompt-message', function(e) {
        if (e.key === 'Enter' && !e.shiftKey) {
            e.preventDefault();
            sendMessage();
        }
    });

    function sendMessage() {
        let chat_bot_thread_id = $('.chat_bot_thread_id').val();
        let prompt = $('.prompt-message').val();
        if(prompt == '' || prompt == null){
            alert('{{ localize("Please type your message") }}')
            return;
        }
        newUserMessage(prompt)
        $('.prompt-message').val('');
        $('#send-btn').prop('disabled', true);

        let data = {
            chat_bot_thread_id,
            prompt,
            _token: '{{ csrf_token() }}'
        }

        askAI(data);
    }
    
    function newUserMessage(prompt) {
        let html =  `
            <div class="message user"> 
                <div class="bubble">
                    ${prompt}
                </div>
            </div>
        `;
        $('#chatBox').append(html); 
    }

    function askAI(data) {
        var callParams      = {};
        callParams.type     = "POST";
        callParams.url      = "{{ route('chatbot.chatbotThreadNewMessage') }}";
        callParams.data     = data;

        callParams.complete = function() {
            // $('#send-btn').prop('disabled', false);
        }

        ajaxCall(callParams, function (result) {
            // Event Source Streaming
            eventSourceStreaming(data);
        }, function onErrorData(err, type, httpStatus) {});
    }

    function saveResponse(data) {
        var callParams      = {};
        callParams.type     = "POST";
        callParams.url      = "{{ route('chatbot.saveResponse') }}";
        callParams.data     = data;
 

        ajaxCall(callParams, function (result) {
            // do nothing
        }, function onErrorData(err, type, httpStatus) {});
    }

    function appendExpertBody() {
        let expertImg = "{{ avatarImage($chatbot?->avatar) }}";
        let html = `
            <div class="message bot">
                <img class="avatar" src="${expertImg}" alt="bot">
                <div class="bubble">
                    ...
                </div>
            </div> 
        `;
        $('#chatBox').append(html); 
    }
    

    function eventSourceStreaming(data) {

        let streamFormData = $.param(data);
        let real_time_data = false;

        streamFormData +="&real_time_data=" + real_time_data

        const URL_CHAT      = "{{ route('chatbot.conversation') }}";

        TT.eventSource = new EventSource(`${URL_CHAT}?${streamFormData}`, {
            withCredentials: true
        });

        // On Message
        TT.eventSource.onmessage = function(e) {
            initScrollToChatBottomThisPage();
            if (!window.onMessageArrived) {
                window.onMessageArrived = true;
                appendExpertBody();
            }

            if (e.data.indexOf("[DONE]") !== -1) {
                saveResponse({
                    chat_bot_thread_id: data.chat_bot_thread_id,
                    response: convertToHtml(window.content_response),
                    _token: data._token
                })

                $('#send-btn').prop('disabled', false);
                TT.eventSource.close();
            }
            else {
                let txt = undefined;
                try {
                    txt = JSON.parse(e.data).choices[0].delta.content;
                    window.content_response = (window.content_response ?? "") + txt;

                    if (txt !== undefined) {
                        let finalText = convertToHtml(window.content_response);
                        
                        $("#chatBox .message:last .bubble").html(finalText);
                    }
                }
                catch (e) {
                    $('#send-btn').prop('disabled', false);
                }
            }

            initScrollToChatBottomThisPage();
        };

        // On Error
        TT.eventSource.onerror = function(e) {
            saveResponse({
                chat_bot_thread_id: data.chat_bot_thread_id,
                response: convertToHtml(window.content_response),
                _token: data._token
            })

            console.log("Error is", TT.eventSource.readyState, "Error Message : ",e , "Error Data : ", e.data);

            // Check the readyState to confirm if the connection was closed
            if (TT.eventSource.readyState === EventSource.CLOSED) {
                console.log("Connection closed.");
            }
            else {
                // If it's an error event, parse and handle the error
                try {
                    // Try parsing the error response from e.data
                    const errorData = JSON.parse(e.data);
                    console.error("Error Message: ", errorData.message);
                    console.error("Details: ", errorData.errors);
                } catch (error) {
                    console.error("Error parsing data: ", e.data);
                }
            }

            TT.eventSource.close(); // Close the connection

            $('#send-btn').prop('disabled', false);
        };
        $('#send-btn').prop('disabled', false);
    }

    function initScrollToChatBottomThisPage() {
        let ChatDiv = $(".chat-wrapper");
        let height = ChatDiv[0]?.scrollHeight;
        ChatDiv.scrollTop(height);
    }
 
    $(document).on('click', '.new-chat', function(e) {
        var callParams      = {};
        callParams.type     = "POST";
        callParams.dataType = "html";
        callParams.url      = "{{ route('chatbot.chatbotNewThread') }}";

        let data = {
            uuid: '{{ $chatbot->uuid }}',
            _token: '{{ csrf_token() }}'
        }
        callParams.data     = data; 

        ajaxCall(callParams, function (result) {
            $('.chat-list').empty().html(result);
            handleChatClick();
            let id = $('.chat-item').first().data('id');
            getChatThreadMessages(id);
        }, function onErrorData(err, type, httpStatus) {});
        
    });

</script>