@forelse($list ?? [] as $key => $row)
        <div class="col-lg-3 col-md-6">
            <div class="tt-single-expert  p-3 rounded-3">
                <a class="d-flex align-content-center" target="_blank">
                    <div class="avatar avatar-md">
                        @if ($row->avatar)
                            <img class="rounded-circle" src="{{ avatarImage($row->avatar) }}" alt="{{ $row->bot_name }}" />
                        @else
                            <img class="rounded-circle" src="{{ asset('assets/img/avatar/4.jpg') }}" alt="{{ $row->bot_name }}" />
                        @endif
                    </div>
                    <div class="tt-expert-info ms-2 d-flex align-items-center">
                        <h6 class="mb-0">{{ $row->bot_name }}</h6>
                    </div>
                </a> 
                <div class="tt-expert-chat d-flex align-items-center gap-2 position-absolute">
                    @include("common.active-status-button",[
                        'active' => $row->is_active,
                        'id'     => encrypt($row->id),
                        'model'  => 'chat_bots',
                        'name'   => 'is_active',
                    ])
                    <a class="link d-inline-block cursor-pointer editIcon" data-id={{ $row->id }} data-bs-toggle="tooltip" data-bs-placement="top" title="{{ localize('Edit Bot Information') }}">
                        <i data-feather="edit-3" class="icon-16"></i>
                    </a>
                    
                    <a class="link d-inline-block cursor-pointer" onclick="copyEmbeddedCode('{{ $row->uuid }}')" data-uuid={{ $row->uuid }} data-bs-toggle="tooltip" data-bs-placement="top" title="{{ localize('Copy Embedded Code') }}">
                        <i data-feather="copy" class="icon-16"></i>
                    </a>
                </div>  
            </div>
        </div>
@empty
    <x-common.empty-div />
@endforelse

{{ paginationFooterDiv($list) }}

