<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $chatbot->bot_name }}</title>
    @include('externalaichat::chat-bots.chat-css')
    <script>
        var TT = {};
    </script>
</head>
<body>
    <div class="chat-container">
        <div class="chat-header">
            {{ $chatbot->bot_name }}
        </div>
        <div class="chat_list_btn_wrapper">
           
                {{-- chat list --}}
                <ul class="chat-list"> 
                    {{-- list appears here via ajax --}}
                </ul>
                {{-- chat list ends --}}


                <div class="chat-wrapper">
                    <div class="chat-box" id="chatBox"> 
                        {{-- messages appears here via ajax --}}
                    </div>

                    <!-- Chat Input Area -->
                    <div class="chat-input-area">
                        <button class="send-btn back_btn">{{ localize("Back") }}</button>
                        <input type="text" id="userInput" class="prompt-message" placeholder="{{ localize("Type a Message...") }}" />
                        <button class="send-btn" id="send-btn" onclick="sendMessage()">{{ localize("Send") }} 🚀</button>
                    </div>
                </div>
            
            <div class="new-chat">📨 {{ localize("Start a New Conversation") }}</div>
        </div>
    </div>

    <script src="{{ asset('assets/js/vendors/jquery-3.6.0.min.js') }}"></script>  
    <script src="{{ asset('assets/js/vendors/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ asset('assets/js/vendors/swiper-bundle.min.js') }}"></script>
    <script src="{{ asset('assets/js/vendors/toastr.min.js') }}"></script>
    <script src="{{ asset('assets/js/vendors/footable.min.js') }}"></script>
    <script src="{{ asset('assets/js/vendors/select2.min.js') }}"></script>
    <script src="{{ asset('assets/js/vendors/feather.min.js') }}"></script>
    <script src="{{ asset('assets/js/vendors/summernote-lite.min.js') }}"></script>
    <script src="{{ asset('assets/js/vendors/summernote-image-attributes.js') }}"></script>
    <script src="{{ asset('assets/js/vendors/flatpickr.min.js') }}"></script>
    <script src="{{ asset('assets/js/vendors/basictable.min.js') }}"></script>
    <script src="{{ asset('assets/js/vendors/prism.js') }}"></script>
    <script src="{{ asset('assets/js/vendors/magnific-popup.min.js') }}"></script>
    <script src="{{ asset('assets/js/vendors/sweetalert2@11.js') }}"></script>
    <script src="{{ asset('assets/js/vendors/jquery-resizable.min.js') }}"></script>
    <script src="{{ asset('assets/js/vendors/jquery-resizableTableColumns.min.js') }}"></script>
    <script src="{{ asset('assets/libs/codemirror/js/codemirror.min.js')}}"></script>
    <script src="{{ asset('assets/libs/codemirror/js/javascript.min.js')}}"></script>
    <script src="{{ asset('assets/js/markdown-it.min.js')}}"></script>
    <script src="{{ asset('assets/js/app.js') }}"></script>

    @include('externalaichat::chat-bots.chat-js')
</body>
</html>