<form action="{{ route('admin.chat-bots.store') }}" method="POST" id="addExpertFrm">
    <div class="offcanvas offcanvas-end" id="addExpertFormSidebar" tabindex="-1">
        @csrf
        @method("POST")
        <x-form.input name="id" id="id" type="hidden" value="" showDiv=0 />
        <div class="offcanvas-header border-bottom py-3">
            <h5 class="offcanvas-title">{{ localize('Add New Chat Bot') }}</h5>
            <span class="tt-close-btn" data-bs-dismiss="offcanvas">
                <i data-feather="x"></i>
            </span>
        </div>
        <x-common.splitter />
        <div class="offcanvas-body">
            <x-common.message class="mb-3" />

            <div class="mb-3">
                <x-form.label for="bot_name" label="{{ localize('Chatbot Name') }}" isRequired=true />
                <x-form.input name="bot_name" id="bot_name" type="text" placeholder="{{ localize('Chatbot Name') }}" value="" showDiv=false />
            </div>

            <div class="mb-3">
                <div class="mb-4">
                    <x-form.label for="avatar" label="{{ localize('Avatar') }}"  />
                    <div class="tt-image-drop rounded">
                        <span class="fw-semibold">{{ localize('Choose Avatar') }}</span>
                        <!-- choose media -->
                        <div class="tt-product-thumb show-selected-files mt-3">
                            <div class="avatar avatar-xl cursor-pointer choose-media"
                                data-bs-toggle="offcanvas" data-bs-target="#offcanvasBottom"
                                onclick="showMediaManager(this)" data-selection="single">
                                <input type="hidden" name="avatar" id="avatar">
                                <div class="no-avatar rounded-circle">
                                    <span><i data-feather="plus"></i></span>
                                </div>
                            </div>
                        </div>
                        <!-- choose media -->
                    </div>

                </div>
            </div>
            
            <div class="mb-3">
                <x-form.label for="bubble_message" label="{{ localize('Bubble Message') }}" isRequired=true />
                <x-form.input name="bubble_message" id="bubble_message" type="text" placeholder="{{ localize('Bubble Message') }}" value="" showDiv=false />
            </div>
            
            <div class="mb-3">
                <x-form.label for="welcome_message" label="{{ localize('Welcome Message') }}" isRequired=true />
                <x-form.input name="welcome_message" id="welcome_message" type="text" placeholder="{{ localize('Welcome Message') }}" value="" showDiv=false />
            </div>
            
            <div class="mb-3">
                <x-form.label for="instructions" label="{{ localize('Instructions') }}" />
                <x-form.textarea name="instructions" id="instructions" type="text" placeholder="{{ localize('Instructions') }}" value="" showDiv=false />
            </div>
            
            <div class="mb-3">
                <x-form.label for="color_code" label="{{ localize('Chatbot color') }}" />
                <div class="input-group">
                    <input type="color" name="color_code" id="color_code" class="form-control">
                </div>
            </div>

            <div class="mb-3">
                <x-form.label for="is_active" label="{{ localize('Status') }}" isRequired=true/>
                <x-form.select name="is_active" id="is_active" required>
                    @foreach (appStatic()::STATUS_ARR as $userStatusId => $userStatus)
                        <option value="{{ $userStatusId }}">{{ $userStatus }}</option>
                    @endforeach
                </x-form.select>
            </div>
        </div>
        <div class="offcanvas-footer border-top">
            <div class="d-flex gap-3">
                <x-form.button id="addExpertBtn">{{ localize('Save') }}</x-form.button>
                <x-form.button color="secondary" type="reset">{{ localize('Reset') }}</x-form.button>
            </div>
        </div>
    </div>
</form>
