<?php

use Illuminate\Support\Facades\Route;
use Modules\ExternalAiChat\App\Http\Controllers\ChatBotController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::group(['prefix' => 'admin', 'as' => 'admin.', 'middleware' => ['auth', 'verified', "demo.middleware"]], function () {
    Route::prefix("chat-bots")->name("chat-bots.")->group(function () {
        Route::get("/", [ChatBotController::class, "index"])->name("index");
        Route::post("store", [ChatBotController::class, "store"])->name("store");
        Route::get("/{id}/edit", [ChatBotController::class, "edit"])->name("edit");
        Route::post("{id}", [ChatBotController::class, "update"])->name("update");
    });
});

Route::get("/chatbot/{uuid}", [ChatBotController::class, "chat"])->name("chatbot.chat");
Route::get("/chatbot/details/{uuid}", [ChatBotController::class, "chatbotDetails"])->name("chatbot.details");
Route::get("/chatbot/threads/{uuid}", [ChatBotController::class, "chatbotThreads"])->name("chatbot.threads");
Route::get("/chatbot/threads/messages/{id?}", [ChatBotController::class, "chatbotThreadMessages"])->name("chatbot.threadMessages");
Route::post("chatbot/threads/new-message", [ChatBotController::class, "chatbotThreadNewMessage"])->name("chatbot.chatbotThreadNewMessage");
Route::post("chatbot/threads/new-thread", [ChatBotController::class, "chatbotNewThread"])->name("chatbot.chatbotNewThread");
Route::post("chatbot/threads/save-response", [ChatBotController::class, "saveResponse"])->name("chatbot.saveResponse");
Route::get("chatbot/threads/conversation/stream", [ChatBotController::class, "conversation"])->name("chatbot.conversation");

