<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class PermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        DB::table('permissions')->delete();

        $permissions = array(
            array('id' => '1','display_title' => 'Debugbar openhandler','route' => 'debugbar.openhandler','url' => '_debugbar/open','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '2','display_title' => 'Debugbar clockwork','route' => 'debugbar.clockwork','url' => '_debugbar/clockwork/{id}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '3','display_title' => 'Debugbar assets css','route' => 'debugbar.assets.css','url' => '_debugbar/assets/stylesheets','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '4','display_title' => 'Debugbar assets js','route' => 'debugbar.assets.js','url' => '_debugbar/assets/javascript','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '5','display_title' => 'Debugbar cache delete','route' => 'debugbar.cache.delete','url' => '_debugbar/cache/{key}/{tags?}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '6','display_title' => 'Cashier payment','route' => 'cashier.payment','url' => 'stripe/payment/{id}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '7','display_title' => 'Cashier webhook','route' => 'cashier.webhook','url' => 'stripe/webhook','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '8','display_title' => 'Sanctum csrf-cookie','route' => 'sanctum.csrf-cookie','url' => 'sanctum/csrf-cookie','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '9','display_title' => 'Laravelpwa manifest','route' => 'laravelpwa.manifest','url' => 'manifest.json','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '10','display_title' => 'Laravelpwa ','route' => 'laravelpwa.','url' => 'offline','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '11','display_title' => 'Ignition healthCheck','route' => 'ignition.healthCheck','url' => '_ignition/health-check','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '12','display_title' => 'Ignition executeSolution','route' => 'ignition.executeSolution','url' => '_ignition/execute-solution','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '13','display_title' => 'Ignition updateConfig','route' => 'ignition.updateConfig','url' => '_ignition/update-config','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '14','display_title' => '','route' => 'api/user','url' => 'api/user','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '15','display_title' => 'Admin index','route' => 'admin.index','url' => 'api/admin','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '16','display_title' => 'Admin store','route' => 'admin.store','url' => 'api/admin/add-admin','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '17','display_title' => 'Generator generateTopics','route' => 'generator.generateTopics','url' => 'api/generator/new-topics','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '18','display_title' => 'Generator generateKeywords','route' => 'generator.generateKeywords','url' => 'api/generator/new-keywords','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '19','display_title' => 'Generator generateTitles','route' => 'generator.generateTitles','url' => 'api/generator/new-titles','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '20','display_title' => 'Generator generateOutlines','route' => 'generator.generateOutlines','url' => 'api/generator/new-outlines','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '21','display_title' => 'SyncWP','route' => 'syncWP','url' => 'sync','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '22','display_title' => 'ConnectWP','route' => 'connectWP','url' => 'connect-wp','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '23','display_title' => 'UploadAPost','route' => 'uploadAPost','url' => 'upload-post','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '24','display_title' => 'ShowPost','route' => 'showPost','url' => 'show/{id}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '25','display_title' => 'GetAllPosts','route' => 'getAllPosts','url' => 'posts','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '26','display_title' => 'Login','route' => 'login','url' => 'login','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '27','display_title' => '','route' => 'login','url' => 'login','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '28','display_title' => 'Logout','route' => 'logout','url' => 'logout','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '29','display_title' => 'Register','route' => 'register','url' => 'register','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '30','display_title' => '','route' => 'register','url' => 'register','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '31','display_title' => 'Password request','route' => 'password.request','url' => 'password/reset','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '32','display_title' => 'Password email','route' => 'password.email','url' => 'password/email','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '33','display_title' => 'Password reset','route' => 'password.reset','url' => 'password/reset/{token}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '34','display_title' => 'Password update','route' => 'password.update','url' => 'password/reset','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '35','display_title' => 'Password confirm','route' => 'password.confirm','url' => 'password/confirm','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '36','display_title' => '','route' => 'password/confirm','url' => 'password/confirm','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '37','display_title' => 'List','route' => 'list','url' => 'listing','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '38','display_title' => 'Stripe checkout','route' => 'stripe.checkout','url' => 'stripe/checkout/plan/{stripe_plan}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '39','display_title' => 'Stripe success','route' => 'stripe.success','url' => 'stripe/success','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '40','display_title' => 'Stripe cancel','route' => 'stripe.cancel','url' => 'stripe/cancel','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '41','display_title' => 'Admin dashboard','route' => 'admin.dashboard','url' => 'admin/dashboard','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '42','display_title' => 'Admin status update','route' => 'admin.status.update','url' => 'admin/update/active-status','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '43','display_title' => 'Admin permissions index','route' => 'admin.permissions.index','url' => 'admin/user-role-management/permissions','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '44','display_title' => 'Admin permissions create','route' => 'admin.permissions.create','url' => 'admin/user-role-management/permissions/create','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '45','display_title' => 'Admin permissions store','route' => 'admin.permissions.store','url' => 'admin/user-role-management/permissions','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '46','display_title' => 'Admin permissions show','route' => 'admin.permissions.show','url' => 'admin/user-role-management/permissions/{permission}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '47','display_title' => 'Admin permissions edit','route' => 'admin.permissions.edit','url' => 'admin/user-role-management/permissions/{permission}/edit','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '48','display_title' => 'Admin permissions update','route' => 'admin.permissions.update','url' => 'admin/user-role-management/permissions/{permission}','method_type' => 'PUT','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '49','display_title' => 'Admin permissions destroy','route' => 'admin.permissions.destroy','url' => 'admin/user-role-management/permissions/{permission}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '50','display_title' => 'Admin roles index','route' => 'admin.roles.index','url' => 'admin/user-role-management/roles','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '51','display_title' => 'Admin roles create','route' => 'admin.roles.create','url' => 'admin/user-role-management/roles/create','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '52','display_title' => 'Admin roles store','route' => 'admin.roles.store','url' => 'admin/user-role-management/roles','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '53','display_title' => 'Admin roles show','route' => 'admin.roles.show','url' => 'admin/user-role-management/roles/{role}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:21','updated_at' => '2024-08-26 11:18:21'),
            array('id' => '54','display_title' => 'Admin roles edit','route' => 'admin.roles.edit','url' => 'admin/user-role-management/roles/{role}/edit','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '55','display_title' => 'Admin roles update','route' => 'admin.roles.update','url' => 'admin/user-role-management/roles/{role}','method_type' => 'PUT','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '56','display_title' => 'Admin roles destroy','route' => 'admin.roles.destroy','url' => 'admin/user-role-management/roles/{role}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '57','display_title' => 'Admin users index','route' => 'admin.users.index','url' => 'admin/user-role-management/users','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '58','display_title' => 'Admin users create','route' => 'admin.users.create','url' => 'admin/user-role-management/users/create','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '59','display_title' => 'Admin users store','route' => 'admin.users.store','url' => 'admin/user-role-management/users','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '60','display_title' => 'Admin users show','route' => 'admin.users.show','url' => 'admin/user-role-management/users/{user}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '61','display_title' => 'Admin users edit','route' => 'admin.users.edit','url' => 'admin/user-role-management/users/{user}/edit','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '62','display_title' => 'Admin users update','route' => 'admin.users.update','url' => 'admin/user-role-management/users/{user}','method_type' => 'PUT','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '63','display_title' => 'Admin users destroy','route' => 'admin.users.destroy','url' => 'admin/user-role-management/users/{user}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '64','display_title' => 'Admin store','route' => 'admin.store','url' => 'admin/add-admin','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '65','display_title' => 'Admin edit','route' => 'admin.edit','url' => 'admin/update-admin/{id}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '66','display_title' => 'Admin update','route' => 'admin.update','url' => 'admin/update-admin/{id}','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '67','display_title' => 'Admin status','route' => 'admin.status','url' => 'admin/update-admin-status/{id}','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '68','display_title' => 'Admin delete','route' => 'admin.delete','url' => 'admin/delete-admin/{id}','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '69','display_title' => 'Admin openai chats index','route' => 'admin.openai.chats.index','url' => 'admin/openai/chats','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '70','display_title' => 'Admin openai chats create','route' => 'admin.openai.chats.create','url' => 'admin/openai/chats/create','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '71','display_title' => 'Admin openai chats store','route' => 'admin.openai.chats.store','url' => 'admin/openai/chats','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '72','display_title' => 'Admin openai chats show','route' => 'admin.openai.chats.show','url' => 'admin/openai/chats/{chat}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '73','display_title' => 'Admin openai chats edit','route' => 'admin.openai.chats.edit','url' => 'admin/openai/chats/{chat}/edit','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '74','display_title' => 'Admin openai chats update','route' => 'admin.openai.chats.update','url' => 'admin/openai/chats/{chat}','method_type' => 'PUT','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '75','display_title' => 'Admin openai chats destroy','route' => 'admin.openai.chats.destroy','url' => 'admin/openai/chats/{chat}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '76','display_title' => 'Admin openai chats code-generator','route' => 'admin.openai.chats.code-generator','url' => 'admin/openai/chats/code-generator/hub','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '77','display_title' => 'Admin openai chats contentGenerator','route' => 'admin.openai.chats.contentGenerator','url' => 'admin/openai/chats/content-generator','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '78','display_title' => 'Admin profile','route' => 'admin.profile','url' => 'admin/profile','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '79','display_title' => 'Admin info-update','route' => 'admin.info-update','url' => 'admin/profile-info-update','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '80','display_title' => 'Admin change-password','route' => 'admin.change-password','url' => 'admin/profile-change-password','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '81','display_title' => 'Admin articles index','route' => 'admin.articles.index','url' => 'admin/articles','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '82','display_title' => 'Admin articles create','route' => 'admin.articles.create','url' => 'admin/articles/create','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '83','display_title' => 'Admin articles store','route' => 'admin.articles.store','url' => 'admin/articles','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '84','display_title' => 'Admin articles show','route' => 'admin.articles.show','url' => 'admin/articles/{article}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '85','display_title' => 'Admin articles edit','route' => 'admin.articles.edit','url' => 'admin/articles/{article}/edit','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '86','display_title' => 'Admin articles update','route' => 'admin.articles.update','url' => 'admin/articles/{article}','method_type' => 'PUT','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '87','display_title' => 'Admin articles destroy','route' => 'admin.articles.destroy','url' => 'admin/articles/{article}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '88','display_title' => 'Admin generator generateTopics','route' => 'admin.generator.generateTopics','url' => 'admin/generator/new-topics','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '89','display_title' => 'Admin generator generateKeywords','route' => 'admin.generator.generateKeywords','url' => 'admin/generator/new-keywords','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '90','display_title' => 'Admin generator generateTitles','route' => 'admin.generator.generateTitles','url' => 'admin/generator/new-titles','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '91','display_title' => 'Admin generator generateOutlines','route' => 'admin.generator.generateOutlines','url' => 'admin/generator/new-outlines','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '92','display_title' => 'Admin generator generateImages','route' => 'admin.generator.generateImages','url' => 'admin/generator/new-images','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '93','display_title' => 'Admin generator generateArticles','route' => 'admin.generator.generateArticles','url' => 'admin/generator/new-articles','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '94','display_title' => 'Admin users updateBalance','route' => 'admin.users.updateBalance','url' => 'admin/users/balance-update','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '95','display_title' => 'Admin template-categories index','route' => 'admin.template-categories.index','url' => 'admin/template-categories','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '96','display_title' => 'Admin template-categories create','route' => 'admin.template-categories.create','url' => 'admin/template-categories/create','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '97','display_title' => 'Admin template-categories store','route' => 'admin.template-categories.store','url' => 'admin/template-categories','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '98','display_title' => 'Admin template-categories show','route' => 'admin.template-categories.show','url' => 'admin/template-categories/{template_category}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '99','display_title' => 'Admin template-categories edit','route' => 'admin.template-categories.edit','url' => 'admin/template-categories/{template_category}/edit','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '100','display_title' => 'Admin template-categories update','route' => 'admin.template-categories.update','url' => 'admin/template-categories/{template_category}','method_type' => 'PUT','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '101','display_title' => 'Admin template-categories destroy','route' => 'admin.template-categories.destroy','url' => 'admin/template-categories/{template_category}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '102','display_title' => 'Admin templates index','route' => 'admin.templates.index','url' => 'admin/templates','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '103','display_title' => 'Admin templates create','route' => 'admin.templates.create','url' => 'admin/templates/create','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '104','display_title' => 'Admin templates store','route' => 'admin.templates.store','url' => 'admin/templates','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '105','display_title' => 'Admin templates show','route' => 'admin.templates.show','url' => 'admin/templates/{template}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '106','display_title' => 'Admin templates edit','route' => 'admin.templates.edit','url' => 'admin/templates/{template}/edit','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '107','display_title' => 'Admin templates update','route' => 'admin.templates.update','url' => 'admin/templates/{template}','method_type' => 'PUT','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '108','display_title' => 'Admin templates destroy','route' => 'admin.templates.destroy','url' => 'admin/templates/{template}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '109','display_title' => 'Admin templates saveContent','route' => 'admin.templates.saveContent','url' => 'admin/templates/{id}/save-content','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '110','display_title' => 'Admin templates stream','route' => 'admin.templates.stream','url' => 'admin/templates/{id}/streaming','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '111','display_title' => 'Admin folders index','route' => 'admin.folders.index','url' => 'admin/folders','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '112','display_title' => 'Admin folders create','route' => 'admin.folders.create','url' => 'admin/folders/create','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '113','display_title' => 'Admin folders store','route' => 'admin.folders.store','url' => 'admin/folders','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '114','display_title' => 'Admin folders edit','route' => 'admin.folders.edit','url' => 'admin/folders/{folder}/edit','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '115','display_title' => 'Admin folders update','route' => 'admin.folders.update','url' => 'admin/folders/{folder}','method_type' => 'PUT','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '116','display_title' => 'Admin folders destroy','route' => 'admin.folders.destroy','url' => 'admin/folders/{folder}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '117','display_title' => 'Admin folders move-folder-content','route' => 'admin.folders.move-folder-content','url' => 'admin/move-folder-content','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '118','display_title' => 'Admin folders move-folder','route' => 'admin.folders.move-folder','url' => 'admin/move-folder','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '119','display_title' => 'Admin text-to-speeches index','route' => 'admin.text-to-speeches.index','url' => 'admin/text-to-speeches','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '120','display_title' => 'Admin text-to-speeches create','route' => 'admin.text-to-speeches.create','url' => 'admin/text-to-speeches/create','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '121','display_title' => 'Admin text-to-speeches store','route' => 'admin.text-to-speeches.store','url' => 'admin/text-to-speeches','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '122','display_title' => 'Admin text-to-speeches show','route' => 'admin.text-to-speeches.show','url' => 'admin/text-to-speeches/{text_to_speech}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '123','display_title' => 'Admin text-to-speeches edit','route' => 'admin.text-to-speeches.edit','url' => 'admin/text-to-speeches/{text_to_speech}/edit','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '124','display_title' => 'Admin text-to-speeches update','route' => 'admin.text-to-speeches.update','url' => 'admin/text-to-speeches/{text_to_speech}','method_type' => 'PUT','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '125','display_title' => 'Admin text-to-speeches destroy','route' => 'admin.text-to-speeches.destroy','url' => 'admin/text-to-speeches/{text_to_speech}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '126','display_title' => 'Admin ai-writer index','route' => 'admin.ai-writer.index','url' => 'admin/ai-writer','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '127','display_title' => 'Admin ai-writer create','route' => 'admin.ai-writer.create','url' => 'admin/ai-writer/create','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '128','display_title' => 'Admin ai-writer store','route' => 'admin.ai-writer.store','url' => 'admin/ai-writer','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '129','display_title' => 'Admin ai-writer show','route' => 'admin.ai-writer.show','url' => 'admin/ai-writer/{ai_writer}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '130','display_title' => 'Admin ai-writer edit','route' => 'admin.ai-writer.edit','url' => 'admin/ai-writer/{ai_writer}/edit','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '131','display_title' => 'Admin ai-writer update','route' => 'admin.ai-writer.update','url' => 'admin/ai-writer/{ai_writer}','method_type' => 'PUT','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '132','display_title' => 'Admin ai-writer destroy','route' => 'admin.ai-writer.destroy','url' => 'admin/ai-writer/{ai_writer}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '133','display_title' => 'Admin ai-writer generate','route' => 'admin.ai-writer.generate','url' => 'admin/ai-writer/generate/content','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '134','display_title' => 'Admin ai-writer save-change','route' => 'admin.ai-writer.save-change','url' => 'admin/ai-writer/generate/save-change','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '135','display_title' => 'Admin media-managers index','route' => 'admin.media-managers.index','url' => 'admin/media-managers','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '136','display_title' => 'Admin media-managers create','route' => 'admin.media-managers.create','url' => 'admin/media-managers/create','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '137','display_title' => 'Admin media-managers store','route' => 'admin.media-managers.store','url' => 'admin/media-managers','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '138','display_title' => 'Admin media-managers show','route' => 'admin.media-managers.show','url' => 'admin/media-managers/{media_manager}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '139','display_title' => 'Admin media-managers edit','route' => 'admin.media-managers.edit','url' => 'admin/media-managers/{media_manager}/edit','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '140','display_title' => 'Admin media-managers update','route' => 'admin.media-managers.update','url' => 'admin/media-managers/{media_manager}','method_type' => 'PUT','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '141','display_title' => 'Admin media-managers destroy','route' => 'admin.media-managers.destroy','url' => 'admin/media-managers/{media_manager}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '142','display_title' => 'Admin chat-categories index','route' => 'admin.chat-categories.index','url' => 'admin/chat-categories','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '143','display_title' => 'Admin chat-categories create','route' => 'admin.chat-categories.create','url' => 'admin/chat-categories/create','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '144','display_title' => 'Admin chat-categories store','route' => 'admin.chat-categories.store','url' => 'admin/chat-categories','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '145','display_title' => 'Admin chat-categories show','route' => 'admin.chat-categories.show','url' => 'admin/chat-categories/{chat_category}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '146','display_title' => 'Admin chat-categories edit','route' => 'admin.chat-categories.edit','url' => 'admin/chat-categories/{chat_category}/edit','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '147','display_title' => 'Admin chat-categories update','route' => 'admin.chat-categories.update','url' => 'admin/chat-categories/{chat_category}','method_type' => 'PUT','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '148','display_title' => 'Admin chat-categories destroy','route' => 'admin.chat-categories.destroy','url' => 'admin/chat-categories/{chat_category}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '149','display_title' => 'Admin chats index','route' => 'admin.chats.index','url' => 'admin/chats','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '150','display_title' => 'Admin chats store','route' => 'admin.chats.store','url' => 'admin/chats/store','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '151','display_title' => 'Admin chats chatThreadConversation','route' => 'admin.chats.chatThreadConversation','url' => 'admin/chats/chat-thread-conversation','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '152','display_title' => 'Admin chats conversation','route' => 'admin.chats.conversation','url' => 'admin/chats/conversation','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '153','display_title' => 'Admin chats aiImageChat','route' => 'admin.chats.aiImageChat','url' => 'admin/chats/ai-image-chat','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '154','display_title' => 'Admin chats aiVisionChat','route' => 'admin.chats.aiVisionChat','url' => 'admin/chats/ai-vision-chat','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '155','display_title' => 'Admin chats aiPDFChat','route' => 'admin.chats.aiPDFChat','url' => 'admin/chats/ai-pdf-chat','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '156','display_title' => 'Admin chats pdfChatEmbedding','route' => 'admin.chats.pdfChatEmbedding','url' => 'admin/chats/ai-pdf-chat/pdf-chat-embedding','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '157','display_title' => 'Admin chats pdfChatCompletion','route' => 'admin.chats.pdfChatCompletion','url' => 'admin/chats/ai-pdf-chat/pdf-chat','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '158','display_title' => 'Admin chats destroy','route' => 'admin.chats.destroy','url' => 'admin/chats/ai-pdf-chat/destroy-pdf-chat','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '159','display_title' => 'Admin chat-experts index','route' => 'admin.chat-experts.index','url' => 'admin/chat-experts','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '160','display_title' => 'Admin chat-experts create','route' => 'admin.chat-experts.create','url' => 'admin/chat-experts/create','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '161','display_title' => 'Admin chat-experts store','route' => 'admin.chat-experts.store','url' => 'admin/chat-experts','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '162','display_title' => 'Admin chat-experts show','route' => 'admin.chat-experts.show','url' => 'admin/chat-experts/{chat_expert}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '163','display_title' => 'Admin chat-experts edit','route' => 'admin.chat-experts.edit','url' => 'admin/chat-experts/{chat_expert}/edit','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '164','display_title' => 'Admin chat-experts update','route' => 'admin.chat-experts.update','url' => 'admin/chat-experts/{chat_expert}','method_type' => 'PUT','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '165','display_title' => 'Admin chat-experts destroy','route' => 'admin.chat-experts.destroy','url' => 'admin/chat-experts/{chat_expert}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '166','display_title' => 'Admin generated-content show','route' => 'admin.generated-content.show','url' => 'admin/generated-content/show/{id}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '167','display_title' => 'Admin generated-content update','route' => 'admin.generated-content.update','url' => 'admin/generated-content/update','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '168','display_title' => 'Admin generated-content destroy','route' => 'admin.generated-content.destroy','url' => 'admin/generated-content/destroy','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '169','display_title' => 'Admin documents index','route' => 'admin.documents.index','url' => 'admin/documents','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '170','display_title' => 'Admin settings index','route' => 'admin.settings.index','url' => 'admin/settings','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '171','display_title' => 'Admin settings create','route' => 'admin.settings.create','url' => 'admin/settings/create','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '172','display_title' => 'Admin settings store','route' => 'admin.settings.store','url' => 'admin/settings','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '173','display_title' => 'Admin settings show','route' => 'admin.settings.show','url' => 'admin/settings/{setting}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '174','display_title' => 'Admin settings edit','route' => 'admin.settings.edit','url' => 'admin/settings/{setting}/edit','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '175','display_title' => 'Admin settings update','route' => 'admin.settings.update','url' => 'admin/settings/{setting}','method_type' => 'PUT','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '176','display_title' => 'Admin settings destroy','route' => 'admin.settings.destroy','url' => 'admin/settings/{setting}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '177','display_title' => 'Admin settings credentials','route' => 'admin.settings.credentials','url' => 'admin/settings-credentials','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '178','display_title' => 'Admin images index','route' => 'admin.images.index','url' => 'admin/images','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '179','display_title' => 'Admin images generateImage','route' => 'admin.images.generateImage','url' => 'admin/images/generate-image','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '180','display_title' => 'Admin images dallE2','route' => 'admin.images.dallE2','url' => 'admin/images/dall-e-2','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '181','display_title' => 'Admin images dallE3','route' => 'admin.images.dallE3','url' => 'admin/images/dall-e-3','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '182','display_title' => 'Admin images sdText2Image','route' => 'admin.images.sdText2Image','url' => 'admin/images/sd-text-2-image','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '183','display_title' => 'Admin images sdImage2ImageMultiPrompt','route' => 'admin.images.sdImage2ImageMultiPrompt','url' => 'admin/images/sd-image-2-image-multi-prompt','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '184','display_title' => 'Admin images sdImage2ImagePrompt','route' => 'admin.images.sdImage2ImagePrompt','url' => 'admin/images/sd-image-2-image-prompt','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '185','display_title' => 'Admin images sdImage2ImageMasking','route' => 'admin.images.sdImage2ImageMasking','url' => 'admin/images/sd-image-2-image-masking','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '186','display_title' => 'Admin images sdImage2ImageUpscale','route' => 'admin.images.sdImage2ImageUpscale','url' => 'admin/images/sd-image-2-image-upscale','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '187','display_title' => 'Admin images destroy','route' => 'admin.images.destroy','url' => 'admin/images/destroy/{id}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '188','display_title' => 'Admin videos index','route' => 'admin.videos.index','url' => 'admin/videos','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '189','display_title' => 'Admin videos sdImage2Video','route' => 'admin.videos.sdImage2Video','url' => 'admin/videos/ai-image-to-video','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '190','display_title' => 'Admin languages index','route' => 'admin.languages.index','url' => 'admin/languages','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '191','display_title' => 'Admin languages create','route' => 'admin.languages.create','url' => 'admin/languages/create','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '192','display_title' => 'Admin languages store','route' => 'admin.languages.store','url' => 'admin/languages','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '193','display_title' => 'Admin languages show','route' => 'admin.languages.show','url' => 'admin/languages/{language}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '194','display_title' => 'Admin languages edit','route' => 'admin.languages.edit','url' => 'admin/languages/{language}/edit','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '195','display_title' => 'Admin languages update','route' => 'admin.languages.update','url' => 'admin/languages/{language}','method_type' => 'PUT','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '196','display_title' => 'Admin languages destroy','route' => 'admin.languages.destroy','url' => 'admin/languages/{language}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '197','display_title' => 'Admin localizations store','route' => 'admin.localizations.store','url' => 'admin/localizations','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '198','display_title' => 'Admin localizations show','route' => 'admin.localizations.show','url' => 'admin/localizations/{localization}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '199','display_title' => 'Admin currencies index','route' => 'admin.currencies.index','url' => 'admin/currencies','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '200','display_title' => 'Admin currencies create','route' => 'admin.currencies.create','url' => 'admin/currencies/create','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '201','display_title' => 'Admin currencies store','route' => 'admin.currencies.store','url' => 'admin/currencies','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '202','display_title' => 'Admin currencies show','route' => 'admin.currencies.show','url' => 'admin/currencies/{currency}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '203','display_title' => 'Admin currencies edit','route' => 'admin.currencies.edit','url' => 'admin/currencies/{currency}/edit','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '204','display_title' => 'Admin currencies update','route' => 'admin.currencies.update','url' => 'admin/currencies/{currency}','method_type' => 'PUT','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '205','display_title' => 'Admin currencies destroy','route' => 'admin.currencies.destroy','url' => 'admin/currencies/{currency}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '206','display_title' => 'Admin uppy index','route' => 'admin.uppy.index','url' => 'admin/media-manager/get-files','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '207','display_title' => 'Admin uppy selectedFiles','route' => 'admin.uppy.selectedFiles','url' => 'admin/media-manager/get-selected-files','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '208','display_title' => 'Admin uppy store','route' => 'admin.uppy.store','url' => 'admin/media-manager/add-files','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:22','updated_at' => '2024-08-26 11:18:22'),
            array('id' => '209','display_title' => 'Admin uppy delete','route' => 'admin.uppy.delete','url' => 'admin/media-manager/delete-files/{id}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '210','display_title' => 'Admin tags index','route' => 'admin.tags.index','url' => 'admin/tags','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '211','display_title' => 'Admin tags create','route' => 'admin.tags.create','url' => 'admin/tags/create','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '212','display_title' => 'Admin tags store','route' => 'admin.tags.store','url' => 'admin/tags','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '213','display_title' => 'Admin tags show','route' => 'admin.tags.show','url' => 'admin/tags/{tag}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '214','display_title' => 'Admin tags edit','route' => 'admin.tags.edit','url' => 'admin/tags/{tag}/edit','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '215','display_title' => 'Admin tags update','route' => 'admin.tags.update','url' => 'admin/tags/{tag}','method_type' => 'PUT','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '216','display_title' => 'Admin tags destroy','route' => 'admin.tags.destroy','url' => 'admin/tags/{tag}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '217','display_title' => 'Admin pages index','route' => 'admin.pages.index','url' => 'admin/pages','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '218','display_title' => 'Admin pages create','route' => 'admin.pages.create','url' => 'admin/pages/create','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '219','display_title' => 'Admin pages store','route' => 'admin.pages.store','url' => 'admin/pages','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '220','display_title' => 'Admin pages show','route' => 'admin.pages.show','url' => 'admin/pages/{page}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '221','display_title' => 'Admin pages edit','route' => 'admin.pages.edit','url' => 'admin/pages/{page}/edit','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '222','display_title' => 'Admin pages update','route' => 'admin.pages.update','url' => 'admin/pages/{page}','method_type' => 'PUT','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '223','display_title' => 'Admin pages destroy','route' => 'admin.pages.destroy','url' => 'admin/pages/{page}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '224','display_title' => 'Admin blog-categories index','route' => 'admin.blog-categories.index','url' => 'admin/blog-categories','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '225','display_title' => 'Admin blog-categories create','route' => 'admin.blog-categories.create','url' => 'admin/blog-categories/create','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '226','display_title' => 'Admin blog-categories store','route' => 'admin.blog-categories.store','url' => 'admin/blog-categories','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '227','display_title' => 'Admin blog-categories show','route' => 'admin.blog-categories.show','url' => 'admin/blog-categories/{blog_category}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '228','display_title' => 'Admin blog-categories edit','route' => 'admin.blog-categories.edit','url' => 'admin/blog-categories/{blog_category}/edit','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '229','display_title' => 'Admin blog-categories update','route' => 'admin.blog-categories.update','url' => 'admin/blog-categories/{blog_category}','method_type' => 'PUT','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '230','display_title' => 'Admin blog-categories destroy','route' => 'admin.blog-categories.destroy','url' => 'admin/blog-categories/{blog_category}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '231','display_title' => 'Admin blogs index','route' => 'admin.blogs.index','url' => 'admin/blogs','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '232','display_title' => 'Admin blogs create','route' => 'admin.blogs.create','url' => 'admin/blogs/create','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '233','display_title' => 'Admin blogs store','route' => 'admin.blogs.store','url' => 'admin/blogs','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '234','display_title' => 'Admin blogs show','route' => 'admin.blogs.show','url' => 'admin/blogs/{blog}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '235','display_title' => 'Admin blogs edit','route' => 'admin.blogs.edit','url' => 'admin/blogs/{blog}/edit','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '236','display_title' => 'Admin blogs update','route' => 'admin.blogs.update','url' => 'admin/blogs/{blog}','method_type' => 'PUT','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '237','display_title' => 'Admin blogs destroy','route' => 'admin.blogs.destroy','url' => 'admin/blogs/{blog}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '238','display_title' => 'Admin faqs index','route' => 'admin.faqs.index','url' => 'admin/faqs','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '239','display_title' => 'Admin faqs create','route' => 'admin.faqs.create','url' => 'admin/faqs/create','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '240','display_title' => 'Admin faqs store','route' => 'admin.faqs.store','url' => 'admin/faqs','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '241','display_title' => 'Admin faqs show','route' => 'admin.faqs.show','url' => 'admin/faqs/{faq}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '242','display_title' => 'Admin faqs edit','route' => 'admin.faqs.edit','url' => 'admin/faqs/{faq}/edit','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '243','display_title' => 'Admin faqs update','route' => 'admin.faqs.update','url' => 'admin/faqs/{faq}','method_type' => 'PUT','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '244','display_title' => 'Admin faqs destroy','route' => 'admin.faqs.destroy','url' => 'admin/faqs/{faq}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '245','display_title' => 'Admin support-categories index','route' => 'admin.support-categories.index','url' => 'admin/support-categories','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '246','display_title' => 'Admin support-categories create','route' => 'admin.support-categories.create','url' => 'admin/support-categories/create','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '247','display_title' => 'Admin support-categories store','route' => 'admin.support-categories.store','url' => 'admin/support-categories','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '248','display_title' => 'Admin support-categories show','route' => 'admin.support-categories.show','url' => 'admin/support-categories/{support_category}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '249','display_title' => 'Admin support-categories edit','route' => 'admin.support-categories.edit','url' => 'admin/support-categories/{support_category}/edit','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '250','display_title' => 'Admin support-categories update','route' => 'admin.support-categories.update','url' => 'admin/support-categories/{support_category}','method_type' => 'PUT','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '251','display_title' => 'Admin support-categories destroy','route' => 'admin.support-categories.destroy','url' => 'admin/support-categories/{support_category}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '252','display_title' => 'Admin support-priorities index','route' => 'admin.support-priorities.index','url' => 'admin/support-priorities','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '253','display_title' => 'Admin support-priorities create','route' => 'admin.support-priorities.create','url' => 'admin/support-priorities/create','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '254','display_title' => 'Admin support-priorities store','route' => 'admin.support-priorities.store','url' => 'admin/support-priorities','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '255','display_title' => 'Admin support-priorities show','route' => 'admin.support-priorities.show','url' => 'admin/support-priorities/{support_priority}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '256','display_title' => 'Admin support-priorities edit','route' => 'admin.support-priorities.edit','url' => 'admin/support-priorities/{support_priority}/edit','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '257','display_title' => 'Admin support-priorities update','route' => 'admin.support-priorities.update','url' => 'admin/support-priorities/{support_priority}','method_type' => 'PUT','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '258','display_title' => 'Admin support-priorities destroy','route' => 'admin.support-priorities.destroy','url' => 'admin/support-priorities/{support_priority}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '259','display_title' => 'Admin support-tickets index','route' => 'admin.support-tickets.index','url' => 'admin/support-tickets','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '260','display_title' => 'Admin support-tickets create','route' => 'admin.support-tickets.create','url' => 'admin/support-tickets/create','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '261','display_title' => 'Admin support-tickets store','route' => 'admin.support-tickets.store','url' => 'admin/support-tickets','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '262','display_title' => 'Admin support-tickets show','route' => 'admin.support-tickets.show','url' => 'admin/support-tickets/{support_ticket}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '263','display_title' => 'Admin support-tickets edit','route' => 'admin.support-tickets.edit','url' => 'admin/support-tickets/{support_ticket}/edit','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '264','display_title' => 'Admin support-tickets update','route' => 'admin.support-tickets.update','url' => 'admin/support-tickets/{support_ticket}','method_type' => 'PUT','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '265','display_title' => 'Admin support-tickets destroy','route' => 'admin.support-tickets.destroy','url' => 'admin/support-tickets/{support_ticket}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '266','display_title' => 'Admin support-replies index','route' => 'admin.support-replies.index','url' => 'admin/support-replies','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '267','display_title' => 'Admin support-replies create','route' => 'admin.support-replies.create','url' => 'admin/support-replies/create','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '268','display_title' => 'Admin support-replies store','route' => 'admin.support-replies.store','url' => 'admin/support-replies','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '269','display_title' => 'Admin support-replies show','route' => 'admin.support-replies.show','url' => 'admin/support-replies/{support_reply}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '270','display_title' => 'Admin support-replies edit','route' => 'admin.support-replies.edit','url' => 'admin/support-replies/{support_reply}/edit','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '271','display_title' => 'Admin support-replies update','route' => 'admin.support-replies.update','url' => 'admin/support-replies/{support_reply}','method_type' => 'PUT','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '272','display_title' => 'Admin support-replies destroy','route' => 'admin.support-replies.destroy','url' => 'admin/support-replies/{support_reply}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '273','display_title' => 'Admin support-tickets reply','route' => 'admin.support-tickets.reply','url' => 'admin/support-tickets/reply/{id}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '274','display_title' => 'Admin subscription-plans index','route' => 'admin.subscription-plans.index','url' => 'admin/subscription-plans','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '275','display_title' => 'Admin subscription-plans create','route' => 'admin.subscription-plans.create','url' => 'admin/subscription-plans/create','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '276','display_title' => 'Admin subscription-plans store','route' => 'admin.subscription-plans.store','url' => 'admin/subscription-plans','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '277','display_title' => 'Admin subscription-plans show','route' => 'admin.subscription-plans.show','url' => 'admin/subscription-plans/{subscription_plan}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '278','display_title' => 'Admin subscription-plans edit','route' => 'admin.subscription-plans.edit','url' => 'admin/subscription-plans/{subscription_plan}/edit','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '279','display_title' => 'Admin subscription-plans update','route' => 'admin.subscription-plans.update','url' => 'admin/subscription-plans/{subscription_plan}','method_type' => 'PUT','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '280','display_title' => 'Admin subscription-plans destroy','route' => 'admin.subscription-plans.destroy','url' => 'admin/subscription-plans/{subscription_plan}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '281','display_title' => 'Admin subscription-plans package-update','route' => 'admin.subscription-plans.package-update','url' => 'admin/subscription-plans/package-update','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '282','display_title' => 'Admin subscription-plans get-price','route' => 'admin.subscription-plans.get-price','url' => 'admin/subscription-plans/get-price/{id}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '283','display_title' => 'Admin subscriptions updateTemplates','route' => 'admin.subscriptions.updateTemplates','url' => 'admin/update-package-templates','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '284','display_title' => 'Admin customers index','route' => 'admin.customers.index','url' => 'admin/customers','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '285','display_title' => 'Admin customers create','route' => 'admin.customers.create','url' => 'admin/customers/create','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '286','display_title' => 'Admin customers store','route' => 'admin.customers.store','url' => 'admin/customers','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '287','display_title' => 'Admin customers show','route' => 'admin.customers.show','url' => 'admin/customers/{customer}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '288','display_title' => 'Admin customers edit','route' => 'admin.customers.edit','url' => 'admin/customers/{customer}/edit','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '289','display_title' => 'Admin customers update','route' => 'admin.customers.update','url' => 'admin/customers/{customer}','method_type' => 'PUT','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '290','display_title' => 'Admin customers destroy','route' => 'admin.customers.destroy','url' => 'admin/customers/{customer}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '291','display_title' => 'Admin customers export','route' => 'admin.customers.export','url' => 'admin/customers-export','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '292','display_title' => 'Admin plan-histories index','route' => 'admin.plan-histories.index','url' => 'admin/plan-histories','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '293','display_title' => 'Admin plan-invoice index','route' => 'admin.plan-invoice.index','url' => 'admin/plan-invoice/{id}','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '294','display_title' => 'Admin plan-invoice download','route' => 'admin.plan-invoice.download','url' => 'admin/plan-download/{id}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '295','display_title' => 'Admin voice-to-text create','route' => 'admin.voice-to-text.create','url' => 'admin/voice-to-text/create','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '296','display_title' => 'Admin voice-to-text store','route' => 'admin.voice-to-text.store','url' => 'admin/voice-to-text','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '297','display_title' => 'Admin ai-plagiarism index','route' => 'admin.ai-plagiarism.index','url' => 'admin/ai-plagiarism','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '298','display_title' => 'Admin ai-plagiarism create','route' => 'admin.ai-plagiarism.create','url' => 'admin/ai-plagiarism/create','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '299','display_title' => 'Admin ai-plagiarism store','route' => 'admin.ai-plagiarism.store','url' => 'admin/ai-plagiarism','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '300','display_title' => 'Admin ai-plagiarism show','route' => 'admin.ai-plagiarism.show','url' => 'admin/ai-plagiarism/{ai_plagiarism}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '301','display_title' => 'Admin ai-plagiarism edit','route' => 'admin.ai-plagiarism.edit','url' => 'admin/ai-plagiarism/{ai_plagiarism}/edit','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '302','display_title' => 'Admin ai-plagiarism update','route' => 'admin.ai-plagiarism.update','url' => 'admin/ai-plagiarism/{ai_plagiarism}','method_type' => 'PUT','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '303','display_title' => 'Admin ai-plagiarism destroy','route' => 'admin.ai-plagiarism.destroy','url' => 'admin/ai-plagiarism/{ai_plagiarism}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '304','display_title' => 'Admin ai-detector index','route' => 'admin.ai-detector.index','url' => 'admin/ai-detector','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '305','display_title' => 'Admin ai-detector create','route' => 'admin.ai-detector.create','url' => 'admin/ai-detector/create','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '306','display_title' => 'Admin ai-detector store','route' => 'admin.ai-detector.store','url' => 'admin/ai-detector','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '307','display_title' => 'Admin ai-detector show','route' => 'admin.ai-detector.show','url' => 'admin/ai-detector/{ai_detector}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '308','display_title' => 'Admin ai-detector edit','route' => 'admin.ai-detector.edit','url' => 'admin/ai-detector/{ai_detector}/edit','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '309','display_title' => 'Admin ai-detector update','route' => 'admin.ai-detector.update','url' => 'admin/ai-detector/{ai_detector}','method_type' => 'PUT','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '310','display_title' => 'Admin ai-detector destroy','route' => 'admin.ai-detector.destroy','url' => 'admin/ai-detector/{ai_detector}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '311','display_title' => 'Admin payment-gateways index','route' => 'admin.payment-gateways.index','url' => 'admin/payment-gateways','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '312','display_title' => 'Admin payment-gateways create','route' => 'admin.payment-gateways.create','url' => 'admin/payment-gateways/create','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '313','display_title' => 'Admin payment-gateways store','route' => 'admin.payment-gateways.store','url' => 'admin/payment-gateways','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '314','display_title' => 'Admin payment-gateways show','route' => 'admin.payment-gateways.show','url' => 'admin/payment-gateways/{payment_gateway}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '315','display_title' => 'Admin payment-gateways edit','route' => 'admin.payment-gateways.edit','url' => 'admin/payment-gateways/{payment_gateway}/edit','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '316','display_title' => 'Admin payment-gateways update','route' => 'admin.payment-gateways.update','url' => 'admin/payment-gateways/{payment_gateway}','method_type' => 'PUT','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '317','display_title' => 'Admin payment-gateways destroy','route' => 'admin.payment-gateways.destroy','url' => 'admin/payment-gateways/{payment_gateway}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '318','display_title' => 'Admin reports words','route' => 'admin.reports.words','url' => 'admin/reports/words-generated','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '319','display_title' => 'Admin reports codes','route' => 'admin.reports.codes','url' => 'admin/reports/codes-generated','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '320','display_title' => 'Admin reports images','route' => 'admin.reports.images','url' => 'admin/reports/images-generated','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '321','display_title' => 'Admin reports s2t','route' => 'admin.reports.s2t','url' => 'admin/reports/speech-to-text-generated','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '322','display_title' => 'Admin reports mostUsed','route' => 'admin.reports.mostUsed','url' => 'admin/reports/most-used-templates','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '323','display_title' => 'Admin reports subscriptions','route' => 'admin.reports.subscriptions','url' => 'admin/reports/subscriptions','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '324','display_title' => 'Admin appearance index','route' => 'admin.appearance.index','url' => 'admin/appearance','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '325','display_title' => 'Admin appearance update','route' => 'admin.appearance.update','url' => 'admin/appearance/update','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '326','display_title' => 'Admin client-feedbacks index','route' => 'admin.client-feedbacks.index','url' => 'admin/client-feedbacks','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '327','display_title' => 'Admin client-feedbacks create','route' => 'admin.client-feedbacks.create','url' => 'admin/client-feedbacks/create','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '328','display_title' => 'Admin client-feedbacks store','route' => 'admin.client-feedbacks.store','url' => 'admin/client-feedbacks','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '329','display_title' => 'Admin client-feedbacks show','route' => 'admin.client-feedbacks.show','url' => 'admin/client-feedbacks/{client_feedback}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '330','display_title' => 'Admin client-feedbacks edit','route' => 'admin.client-feedbacks.edit','url' => 'admin/client-feedbacks/{client_feedback}/edit','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '331','display_title' => 'Admin client-feedbacks update','route' => 'admin.client-feedbacks.update','url' => 'admin/client-feedbacks/{client_feedback}','method_type' => 'PUT','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '332','display_title' => 'Admin client-feedbacks destroy','route' => 'admin.client-feedbacks.destroy','url' => 'admin/client-feedbacks/{client_feedback}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '333','display_title' => 'Admin subscription-settings index','route' => 'admin.subscription-settings.index','url' => 'admin/subscription-settings','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '334','display_title' => 'Admin subscription-settings store gateway product','route' => 'admin.subscription-settings.store.gateway.product','url' => 'admin/subscription-settings/gateway-product/store','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '335','display_title' => 'Admin settings adSense index','route' => 'admin.settings.adSense.index','url' => 'admin/ad_sense','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '336','display_title' => 'Admin settings adSense edit','route' => 'admin.settings.adSense.edit','url' => 'admin/ad_sense/{id}/edit','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '337','display_title' => 'Admin settings adSense update','route' => 'admin.settings.adSense.update','url' => 'admin/ad_sense/update/{id}','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '338','display_title' => 'Admin affiliate overview','route' => 'admin.affiliate.overview','url' => 'admin/affiliate/overview','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '339','display_title' => 'Admin affiliate payout configure','route' => 'admin.affiliate.payout.configure','url' => 'admin/affiliate/configure-payouts','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '340','display_title' => 'Admin affiliate payout configureStore','route' => 'admin.affiliate.payout.configureStore','url' => 'admin/affiliate/configure-payouts','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '341','display_title' => 'Admin affiliate withdraw index','route' => 'admin.affiliate.withdraw.index','url' => 'admin/affiliate/withdraw-requests','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '342','display_title' => 'Admin affiliate withdraw store','route' => 'admin.affiliate.withdraw.store','url' => 'admin/affiliate/withdraw-requests','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '343','display_title' => 'Admin affiliate withdraw update','route' => 'admin.affiliate.withdraw.update','url' => 'admin/affiliate/update-requests','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '344','display_title' => 'Admin affiliate earnings index','route' => 'admin.affiliate.earnings.index','url' => 'admin/affiliate/earning-histories','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '345','display_title' => 'Admin affiliate payments index','route' => 'admin.affiliate.payments.index','url' => 'admin/affiliate/payments','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '346','display_title' => 'Admin offline-payment-methods index','route' => 'admin.offline-payment-methods.index','url' => 'admin/offline-payment-methods','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '347','display_title' => 'Admin offline-payment-methods create','route' => 'admin.offline-payment-methods.create','url' => 'admin/offline-payment-methods/create','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '348','display_title' => 'Admin offline-payment-methods store','route' => 'admin.offline-payment-methods.store','url' => 'admin/offline-payment-methods','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '349','display_title' => 'Admin offline-payment-methods show','route' => 'admin.offline-payment-methods.show','url' => 'admin/offline-payment-methods/{offline_payment_method}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '350','display_title' => 'Admin offline-payment-methods edit','route' => 'admin.offline-payment-methods.edit','url' => 'admin/offline-payment-methods/{offline_payment_method}/edit','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '351','display_title' => 'Admin offline-payment-methods update','route' => 'admin.offline-payment-methods.update','url' => 'admin/offline-payment-methods/{offline_payment_method}','method_type' => 'PUT','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '352','display_title' => 'Admin offline-payment-methods destroy','route' => 'admin.offline-payment-methods.destroy','url' => 'admin/offline-payment-methods/{offline_payment_method}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '353','display_title' => 'Admin email-templates index','route' => 'admin.email-templates.index','url' => 'admin/email-templates','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '354','display_title' => 'Admin email-templates update','route' => 'admin.email-templates.update','url' => 'admin/email-templates/update/{id}','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '355','display_title' => 'Admin utilities','route' => 'admin.utilities','url' => 'admin/utilities','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:23','updated_at' => '2024-08-26 11:18:23'),
            array('id' => '356','display_title' => 'Admin clear-cache','route' => 'admin.clear-cache','url' => 'admin/clear-cache','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '357','display_title' => 'Admin clearLog','route' => 'admin.clearLog','url' => 'admin/clear-log','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '358','display_title' => 'Admin debug','route' => 'admin.debug','url' => 'admin/debug','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '359','display_title' => 'Admin cron-list','route' => 'admin.cron-list','url' => 'admin/cron-list','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '360','display_title' => 'Admin team-members index','route' => 'admin.team-members.index','url' => 'admin/team-members','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '361','display_title' => 'Admin team-members create','route' => 'admin.team-members.create','url' => 'admin/team-members/create','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '362','display_title' => 'Admin team-members store','route' => 'admin.team-members.store','url' => 'admin/team-members','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '363','display_title' => 'Admin team-members show','route' => 'admin.team-members.show','url' => 'admin/team-members/{team_member}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '364','display_title' => 'Admin team-members edit','route' => 'admin.team-members.edit','url' => 'admin/team-members/{team_member}/edit','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '365','display_title' => 'Admin team-members update','route' => 'admin.team-members.update','url' => 'admin/team-members/{team_member}','method_type' => 'PUT','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '366','display_title' => 'Admin team-members destroy','route' => 'admin.team-members.destroy','url' => 'admin/team-members/{team_member}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '367','display_title' => 'Admin newsletters index','route' => 'admin.newsletters.index','url' => 'admin/bulk-emails','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '368','display_title' => 'Admin newsletters send','route' => 'admin.newsletters.send','url' => 'admin/bulk-emails/send','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '369','display_title' => 'Admin subscribers index','route' => 'admin.subscribers.index','url' => 'admin/subscribers','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '370','display_title' => 'Admin subscribers destroy','route' => 'admin.subscribers.destroy','url' => 'admin/subscribers/{subscriber}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '371','display_title' => 'Admin recordVoiceToText','route' => 'admin.recordVoiceToText','url' => 'admin/voice-to-text-input','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '372','display_title' => 'Admin about-us index','route' => 'admin.about-us.index','url' => 'admin/about-us','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '373','display_title' => 'Admin contact-us index','route' => 'admin.contact-us.index','url' => 'admin/contact-us','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '374','display_title' => 'Admin contact-us store','route' => 'admin.contact-us.store','url' => 'admin/contact-us','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '375','display_title' => 'Admin queries index','route' => 'admin.queries.index','url' => 'admin/contact-queries','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '376','display_title' => 'Admin queries markRead','route' => 'admin.queries.markRead','url' => 'admin/mark-as-read/{id}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '377','display_title' => 'Admin queries delete','route' => 'admin.queries.delete','url' => 'admin/delete-queries/{id}/{force?}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '378','display_title' => 'Admin queries deleteAll','route' => 'admin.queries.deleteAll','url' => 'admin/delete-all-queries','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '379','display_title' => 'Admin privacy-policy index','route' => 'admin.privacy-policy.index','url' => 'admin/privacy-policy','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '380','display_title' => 'Admin terms-conditions index','route' => 'admin.terms-conditions.index','url' => 'admin/terms-conditions','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '381','display_title' => 'Layouts','route' => 'layouts','url' => '/','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '382','display_title' => 'Templates','route' => 'templates','url' => 'templates','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '383','display_title' => 'Blog','route' => 'blog','url' => 'blogs/{slug}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '384','display_title' => 'ReadPost','route' => 'readPost','url' => 'read','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '385','display_title' => 'ContinueStreaming','route' => 'continueStreaming','url' => 'continue-streaming/{content?}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '386','display_title' => 'WriteRapLogin','route' => 'writeRapLogin','url' => 'write-rap-login','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '387','display_title' => 'Logout','route' => 'logout','url' => 'logout','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '388','display_title' => 'Social login','route' => 'social.login','url' => 'social-login/redirect/{provider}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '389','display_title' => 'Social callback','route' => 'social.callback','url' => 'social-login/{provider}/callback','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '390','display_title' => 'Verification phone','route' => 'verification.phone','url' => 'verify-phone','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '391','display_title' => 'Verification resend','route' => 'verification.resend','url' => 'email/resend','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '392','display_title' => 'Email verification confirmation','route' => 'email.verification.confirmation','url' => 'verification-confirmation/{code}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '393','display_title' => 'Phone verification confirmation','route' => 'phone.verification.confirmation','url' => 'verification-confirmation','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '394','display_title' => 'ForgotPw resetByPhone','route' => 'forgotPw.resetByPhone','url' => 'reset-password-by-phone','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '395','display_title' => 'ForgotPw update','route' => 'forgotPw.update','url' => 'reset-password-by-phone','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '396','display_title' => 'Home','route' => 'home','url' => 'home','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '397','display_title' => 'Dashboard','route' => 'dashboard','url' => 'dashboard','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '398','display_title' => 'Backend changeCurrency','route' => 'backend.changeCurrency','url' => 'backend/change-currency','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '399','display_title' => 'Backend changeLanguage','route' => 'backend.changeLanguage','url' => 'backend/change-language','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '400','display_title' => 'Website subscriptions subscribe','route' => 'website.subscriptions.subscribe','url' => 'subscribe-to-package','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '401','display_title' => 'Website subscriptions index','route' => 'website.subscriptions.index','url' => 'subscribe-to-package','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '402','display_title' => 'Admin staffs index','route' => 'admin.staffs.index','url' => 'admin','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '403','display_title' => 'File-upload','route' => 'file-upload','url' => 'file-upload','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '404','display_title' => 'Test','route' => 'test','url' => 'test','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '405','display_title' => 'Stream','route' => 'stream','url' => 'stream','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '406','display_title' => 'Paypal success','route' => 'paypal.success','url' => 'paypal/success','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '407','display_title' => 'Paypal cancel','route' => 'paypal.cancel','url' => 'paypal/cancel','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '408','display_title' => 'Create payPal order','route' => 'create.payPal.order','url' => 'paypal/create-paypal-order','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '409','display_title' => 'Capture payPal order','route' => 'capture.payPal.order','url' => 'paypal/capture-paypal-order','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '410','display_title' => 'Stripe checkoutSession','route' => 'stripe.checkoutSession','url' => 'stripe/create-session','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '411','display_title' => 'Paytm callback','route' => 'paytm.callback','url' => 'paytm/callback','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '412','display_title' => 'Razorpay payment','route' => 'razorpay.payment','url' => 'razorpay/payment','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '413','display_title' => 'Iyzico callback','route' => 'iyzico.callback','url' => 'iyzico/payment/callback','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '414','display_title' => 'Paystack callback','route' => 'paystack.callback','url' => 'paystack/payment/callback','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '415','display_title' => 'Flutterwave callback','route' => 'flutterwave.callback','url' => 'flutterwave/payment/callback','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '416','display_title' => 'Duitku callback','route' => 'duitku.callback','url' => 'duitku/payment/callback','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '417','display_title' => 'Duitku pay','route' => 'duitku.pay','url' => 'duitku/payment/submit','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '418','display_title' => 'Duitku return','route' => 'duitku.return','url' => 'duitku/payment/return','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '419','display_title' => 'Youkassa finish','route' => 'youkassa.finish','url' => 'youkassa/finish','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '420','display_title' => 'Molile redirect','route' => 'molile.redirect','url' => 'molile/redirect','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '421','display_title' => 'Mercadopago redirect','route' => 'mercadopago.redirect','url' => 'mercadopago/redirect','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '422','display_title' => 'Mercadopago failed','route' => 'mercadopago.failed','url' => 'mercadopago/failed','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '423','display_title' => 'Midtrans callback','route' => 'midtrans.callback','url' => 'midtrans/payment/callback','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '424','display_title' => 'Midtrans success','route' => 'midtrans.success','url' => 'midtrans/payment/finish','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '425','display_title' => 'Midtrans failed','route' => 'midtrans.failed','url' => 'midtrans/payment/unfinish','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '426','display_title' => 'Midtrans error','route' => 'midtrans.error','url' => 'midtrans/payment/error','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '427','display_title' => 'Midtrans payment-notification','route' => 'midtrans.payment-notification','url' => 'midtrans/payment/payment-notification','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '428','display_title' => 'Midtrans pay-account-notification','route' => 'midtrans.pay-account-notification','url' => 'midtrans/payment/pay-account-notification','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '429','display_title' => 'Midtrans recurring-notification','route' => 'midtrans.recurring-notification','url' => 'midtrans/payment/recurring-notification','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '430','display_title' => 'Subscriptions getPackageTemplates','route' => 'subscriptions.getPackageTemplates','url' => 'get-package-templates','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '431','display_title' => 'About-us','route' => 'about-us','url' => 'about-us','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '432','display_title' => 'Privacy-policy','route' => 'privacy-policy','url' => 'privacy-policy','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '433','display_title' => 'Terms-conditions','route' => 'terms-conditions','url' => 'terms-conditions','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '434','display_title' => 'Contact-us','route' => 'contact-us','url' => 'contact-us','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '435','display_title' => 'Contact-us store','route' => 'contact-us.store','url' => 'contact-us','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '436','display_title' => 'Subscribe store','route' => 'subscribe.store','url' => 'subscribe-frontend','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '437','display_title' => 'Api wordpressblog','route' => 'api.wordpressblog','url' => 'api/v1/wordpressblog','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '438','display_title' => 'Wordpressblog index','route' => 'wordpressblog.index','url' => 'wordpressblog','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '439','display_title' => 'Wordpressblog create','route' => 'wordpressblog.create','url' => 'wordpressblog/create','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '440','display_title' => 'Wordpressblog store','route' => 'wordpressblog.store','url' => 'wordpressblog','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '441','display_title' => 'Wordpressblog show','route' => 'wordpressblog.show','url' => 'wordpressblog/{wordpressblog}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '442','display_title' => 'Wordpressblog edit','route' => 'wordpressblog.edit','url' => 'wordpressblog/{wordpressblog}/edit','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '443','display_title' => 'Wordpressblog update','route' => 'wordpressblog.update','url' => 'wordpressblog/{wordpressblog}','method_type' => 'PUT','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '444','display_title' => 'Wordpressblog destroy','route' => 'wordpressblog.destroy','url' => 'wordpressblog/{wordpressblog}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '445','display_title' => 'Admin wordpress-settings index','route' => 'admin.wordpress-settings.index','url' => 'admin/wordpress-settings','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '446','display_title' => 'Admin wordpress-settings store','route' => 'admin.wordpress-settings.store','url' => 'admin/wordpress-settings','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '447','display_title' => 'Admin wordpress-credentials index','route' => 'admin.wordpress-credentials.index','url' => 'admin/wordpress-credentials','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '448','display_title' => 'Admin wordpress-credentials create','route' => 'admin.wordpress-credentials.create','url' => 'admin/wordpress-credentials/create','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '449','display_title' => 'Admin wordpress-credentials store','route' => 'admin.wordpress-credentials.store','url' => 'admin/wordpress-credentials','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '450','display_title' => 'Admin wordpress-credentials show','route' => 'admin.wordpress-credentials.show','url' => 'admin/wordpress-credentials/{wordpress_credential}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '451','display_title' => 'Admin wordpress-credentials edit','route' => 'admin.wordpress-credentials.edit','url' => 'admin/wordpress-credentials/{wordpress_credential}/edit','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '452','display_title' => 'Admin wordpress-credentials update','route' => 'admin.wordpress-credentials.update','url' => 'admin/wordpress-credentials/{wordpress_credential}','method_type' => 'PUT','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '453','display_title' => 'Admin wordpress-credentials destroy','route' => 'admin.wordpress-credentials.destroy','url' => 'admin/wordpress-credentials/{wordpress_credential}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '454','display_title' => 'Admin wordpress-tags index','route' => 'admin.wordpress-tags.index','url' => 'admin/wordpress-tags','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '455','display_title' => 'Admin wordpress-tags create','route' => 'admin.wordpress-tags.create','url' => 'admin/wordpress-tags/create','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '456','display_title' => 'Admin wordpress-tags store','route' => 'admin.wordpress-tags.store','url' => 'admin/wordpress-tags','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '457','display_title' => 'Admin wordpress-tags show','route' => 'admin.wordpress-tags.show','url' => 'admin/wordpress-tags/{wordpress_tag}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '458','display_title' => 'Admin wordpress-tags edit','route' => 'admin.wordpress-tags.edit','url' => 'admin/wordpress-tags/{wordpress_tag}/edit','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '459','display_title' => 'Admin wordpress-tags update','route' => 'admin.wordpress-tags.update','url' => 'admin/wordpress-tags/{wordpress_tag}','method_type' => 'PUT','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '460','display_title' => 'Admin wordpress-tags destroy','route' => 'admin.wordpress-tags.destroy','url' => 'admin/wordpress-tags/{wordpress_tag}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '461','display_title' => 'Admin wordpress-posts index','route' => 'admin.wordpress-posts.index','url' => 'admin/wordpress-posts','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '462','display_title' => 'Admin wordpress-posts create','route' => 'admin.wordpress-posts.create','url' => 'admin/wordpress-posts/create','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '463','display_title' => 'Admin wordpress-posts store','route' => 'admin.wordpress-posts.store','url' => 'admin/wordpress-posts','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '464','display_title' => 'Admin wordpress-posts show','route' => 'admin.wordpress-posts.show','url' => 'admin/wordpress-posts/{wordpress_post}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '465','display_title' => 'Admin wordpress-posts edit','route' => 'admin.wordpress-posts.edit','url' => 'admin/wordpress-posts/{wordpress_post}/edit','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '466','display_title' => 'Admin wordpress-posts update','route' => 'admin.wordpress-posts.update','url' => 'admin/wordpress-posts/{wordpress_post}','method_type' => 'PUT','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '467','display_title' => 'Admin wordpress-posts destroy','route' => 'admin.wordpress-posts.destroy','url' => 'admin/wordpress-posts/{wordpress_post}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '468','display_title' => 'Admin wordpress-categories index','route' => 'admin.wordpress-categories.index','url' => 'admin/wordpress-categories','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '469','display_title' => 'Admin wordpress-categories create','route' => 'admin.wordpress-categories.create','url' => 'admin/wordpress-categories/create','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '470','display_title' => 'Admin wordpress-categories store','route' => 'admin.wordpress-categories.store','url' => 'admin/wordpress-categories','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '471','display_title' => 'Admin wordpress-categories show','route' => 'admin.wordpress-categories.show','url' => 'admin/wordpress-categories/{wordpress_category}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '472','display_title' => 'Admin wordpress-categories edit','route' => 'admin.wordpress-categories.edit','url' => 'admin/wordpress-categories/{wordpress_category}/edit','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '473','display_title' => 'Admin wordpress-categories update','route' => 'admin.wordpress-categories.update','url' => 'admin/wordpress-categories/{wordpress_category}','method_type' => 'PUT','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '474','display_title' => 'Admin wordpress-categories destroy','route' => 'admin.wordpress-categories.destroy','url' => 'admin/wordpress-categories/{wordpress_category}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '475','display_title' => 'Admin sync all tags','route' => 'admin.sync.all.tags','url' => 'admin/sync-all-tags','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '476','display_title' => 'Admin sync all categories','route' => 'admin.sync.all.categories','url' => 'admin/sync-all-categories','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '477','display_title' => 'Admin wordpress-posts-published index','route' => 'admin.wordpress-posts-published.index','url' => 'admin/wordpress-posts-published','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '478','display_title' => 'Admin wordpress-posts-published create','route' => 'admin.wordpress-posts-published.create','url' => 'admin/wordpress-posts-published/create','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '479','display_title' => 'Admin wordpress-posts-published store','route' => 'admin.wordpress-posts-published.store','url' => 'admin/wordpress-posts-published','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '480','display_title' => 'Admin wordpress-posts-published show','route' => 'admin.wordpress-posts-published.show','url' => 'admin/wordpress-posts-published/{wordpress_posts_published}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '481','display_title' => 'Admin wordpress-posts-published edit','route' => 'admin.wordpress-posts-published.edit','url' => 'admin/wordpress-posts-published/{wordpress_posts_published}/edit','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '482','display_title' => 'Admin wordpress-posts-published update','route' => 'admin.wordpress-posts-published.update','url' => 'admin/wordpress-posts-published/{wordpress_posts_published}','method_type' => 'PUT','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '483','display_title' => 'Admin wordpress-posts-published destroy','route' => 'admin.wordpress-posts-published.destroy','url' => 'admin/wordpress-posts-published/{wordpress_posts_published}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '1','is_allowed_in_demo' => '0','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2024-08-26 11:18:24','updated_at' => '2024-08-26 11:18:24'),
            array('id' => '484','display_title' => 'Debugbar queries explain','route' => 'debugbar.queries.explain','url' => '_debugbar/queries/explain','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '485','display_title' => 'Envato products','route' => 'envato.products','url' => 'api/envato/products','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '486','display_title' => 'Admin chat sendInEmail','route' => 'admin.chat.sendInEmail','url' => 'admin/ai-chat-history/send-email','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '487','display_title' => 'Admin chat download','route' => 'admin.chat.download','url' => 'admin/ai-chat-history/download','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '488','display_title' => 'Admin chat delete-conversation','route' => 'admin.chat.delete-conversation','url' => 'admin/ai-chat-history/delete-conversation','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '489','display_title' => 'Admin articles storeArticleMetaOrKeyword','route' => 'admin.articles.storeArticleMetaOrKeyword','url' => 'admin/articles/store-article-meta','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '490','display_title' => 'Admin seo index','route' => 'admin.seo.index','url' => 'admin/seo','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '491','display_title' => 'Admin seo wpPostSeoChecker','route' => 'admin.seo.wpPostSeoChecker','url' => 'admin/seo/article/{id}/wp-post-seo-checker','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '492','display_title' => 'Admin seo storeWpPostSeoChecker','route' => 'admin.seo.storeWpPostSeoChecker','url' => 'admin/seo/article/{id}/wp-post-seo-checker','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '493','display_title' => 'Admin seo articleSeoChecker','route' => 'admin.seo.articleSeoChecker','url' => 'admin/seo/article/{id}/blog-seo-checker','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '494','display_title' => 'Admin seo storeArticleSeoChecker','route' => 'admin.seo.storeArticleSeoChecker','url' => 'admin/seo/article/{id}/article-seo-checker','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '495','display_title' => 'Admin generator imageSearch','route' => 'admin.generator.imageSearch','url' => 'admin/generator/new-image-search','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '496','display_title' => 'Admin generator generateMetaDescriptions','route' => 'admin.generator.generateMetaDescriptions','url' => 'admin/generator/new-meta-description','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '497','display_title' => 'Admin ai-rewriter index','route' => 'admin.ai-rewriter.index','url' => 'admin/ai-rewriter','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '498','display_title' => 'Admin ai-rewriter create','route' => 'admin.ai-rewriter.create','url' => 'admin/ai-rewriter/create','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '499','display_title' => 'Admin ai-rewriter store','route' => 'admin.ai-rewriter.store','url' => 'admin/ai-rewriter','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '500','display_title' => 'Admin ai-rewriter show','route' => 'admin.ai-rewriter.show','url' => 'admin/ai-rewriter/{ai_rewriter}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '501','display_title' => 'Admin ai-rewriter edit','route' => 'admin.ai-rewriter.edit','url' => 'admin/ai-rewriter/{ai_rewriter}/edit','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '502','display_title' => 'Admin ai-rewriter update','route' => 'admin.ai-rewriter.update','url' => 'admin/ai-rewriter/{ai_rewriter}','method_type' => 'PUT','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '503','display_title' => 'Admin ai-rewriter destroy','route' => 'admin.ai-rewriter.destroy','url' => 'admin/ai-rewriter/{ai_rewriter}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '504','display_title' => 'Admin ai-rewriter rewrite','route' => 'admin.ai-rewriter.rewrite','url' => 'admin/ai-rewriter/rewrite','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '505','display_title' => 'Admin prompt-groups index','route' => 'admin.prompt-groups.index','url' => 'admin/prompt-groups','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '506','display_title' => 'Admin prompt-groups create','route' => 'admin.prompt-groups.create','url' => 'admin/prompt-groups/create','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '507','display_title' => 'Admin prompt-groups store','route' => 'admin.prompt-groups.store','url' => 'admin/prompt-groups','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '508','display_title' => 'Admin prompt-groups show','route' => 'admin.prompt-groups.show','url' => 'admin/prompt-groups/{prompt_group}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '509','display_title' => 'Admin prompt-groups edit','route' => 'admin.prompt-groups.edit','url' => 'admin/prompt-groups/{prompt_group}/edit','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '510','display_title' => 'Admin prompt-groups update','route' => 'admin.prompt-groups.update','url' => 'admin/prompt-groups/{prompt_group}','method_type' => 'PUT','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '511','display_title' => 'Admin prompt-groups destroy','route' => 'admin.prompt-groups.destroy','url' => 'admin/prompt-groups/{prompt_group}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '512','display_title' => 'Admin prompts index','route' => 'admin.prompts.index','url' => 'admin/prompts','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '513','display_title' => 'Admin prompts create','route' => 'admin.prompts.create','url' => 'admin/prompts/create','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '514','display_title' => 'Admin prompts store','route' => 'admin.prompts.store','url' => 'admin/prompts','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '515','display_title' => 'Admin prompts show','route' => 'admin.prompts.show','url' => 'admin/prompts/{prompt}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '516','display_title' => 'Admin prompts edit','route' => 'admin.prompts.edit','url' => 'admin/prompts/{prompt}/edit','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '517','display_title' => 'Admin prompts update','route' => 'admin.prompts.update','url' => 'admin/prompts/{prompt}','method_type' => 'PUT','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '518','display_title' => 'Admin prompts destroy','route' => 'admin.prompts.destroy','url' => 'admin/prompts/{prompt}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '519','display_title' => 'Admin group-prompts','route' => 'admin.group-prompts','url' => 'admin/group-prompts','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '520','display_title' => 'Admin images photoStudio index','route' => 'admin.images.photoStudio.index','url' => 'admin/images/photo-studio','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '521','display_title' => 'Admin images photoStudio generatePhotoStudioImage','route' => 'admin.images.photoStudio.generatePhotoStudioImage','url' => 'admin/images/photo-studio/generate-image','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '522','display_title' => 'Admin images productShot index','route' => 'admin.images.productShot.index','url' => 'admin/images/product-shot','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '523','display_title' => 'Admin images productShot generateProductShotImage','route' => 'admin.images.productShot.generateProductShotImage','url' => 'admin/images/product-shot/generate-image','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '524','display_title' => 'Admin videos downloadVideo','route' => 'admin.videos.downloadVideo','url' => 'admin/videos/video/{id}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '525','display_title' => 'Admin plan-histories show','route' => 'admin.plan-histories.show','url' => 'admin/plan-histories/{id}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '526','display_title' => 'Admin voice index','route' => 'admin.voice.index','url' => 'admin/clone/voice','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '527','display_title' => 'Admin voice cloneVoice','route' => 'admin.voice.cloneVoice','url' => 'admin/clone/voice/clone-voice','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '528','display_title' => 'Admin avatarPro index','route' => 'admin.avatarPro.index','url' => 'admin/avatar-pro','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '529','display_title' => 'Admin avatarPro create','route' => 'admin.avatarPro.create','url' => 'admin/avatar-pro/create','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '530','display_title' => 'Admin avatarPro getAvatarsAndTalkingPhotos','route' => 'admin.avatarPro.getAvatarsAndTalkingPhotos','url' => 'admin/avatar-pro/load-avatars-talking-photos','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '531','display_title' => 'Admin avatarPro getVoices','route' => 'admin.avatarPro.getVoices','url' => 'admin/avatar-pro/load-voices','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '532','display_title' => 'Admin avatarPro importAvatarsAndTalkingPhotos','route' => 'admin.avatarPro.importAvatarsAndTalkingPhotos','url' => 'admin/avatar-pro/import-avatars-talking-photos','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '533','display_title' => 'Admin avatarPro importVoices','route' => 'admin.avatarPro.importVoices','url' => 'admin/avatar-pro/import-voices','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '534','display_title' => 'Admin avatarPro getAvatarByAvatarId','route' => 'admin.avatarPro.getAvatarByAvatarId','url' => 'admin/avatar-pro/load-avatars-by-id','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '535','display_title' => 'Admin avatarPro createVideo','route' => 'admin.avatarPro.createVideo','url' => 'admin/avatar-pro/create-video','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '536','display_title' => 'Admin brand-voices index','route' => 'admin.brand-voices.index','url' => 'admin/brand-voices','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '537','display_title' => 'Admin brand-voices create','route' => 'admin.brand-voices.create','url' => 'admin/brand-voices/create','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '538','display_title' => 'Admin brand-voices store','route' => 'admin.brand-voices.store','url' => 'admin/brand-voices','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '539','display_title' => 'Admin brand-voices show','route' => 'admin.brand-voices.show','url' => 'admin/brand-voices/{brand_voice}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '540','display_title' => 'Admin brand-voices edit','route' => 'admin.brand-voices.edit','url' => 'admin/brand-voices/{brand_voice}/edit','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '541','display_title' => 'Admin brand-voices update','route' => 'admin.brand-voices.update','url' => 'admin/brand-voices/{brand_voice}','method_type' => 'PUT','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '542','display_title' => 'Admin brand-voices destroy','route' => 'admin.brand-voices.destroy','url' => 'admin/brand-voices/{brand_voice}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '543','display_title' => 'Admin pwa-settings index','route' => 'admin.pwa-settings.index','url' => 'admin/pwa-settings','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '544','display_title' => 'Admin pwa-settings store','route' => 'admin.pwa-settings.store','url' => 'admin/pwa-settings','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '545','display_title' => 'Admin chat-thread update','route' => 'admin.chat-thread.update','url' => 'admin/chat-thread-update','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '546','display_title' => 'Admin chat-thread destroy','route' => 'admin.chat-thread.destroy','url' => 'admin/chat-thread/{id}','method_type' => 'DELETE','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '547','display_title' => 'Admin balance-render','route' => 'admin.balance-render','url' => 'admin/balance-render','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '548','display_title' => 'Admin download-content','route' => 'admin.download-content','url' => 'admin/download-content','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '549','display_title' => 'Admin payment-requests index','route' => 'admin.payment-requests.index','url' => 'admin/payment-requests','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '550','display_title' => 'Admin payment-requests approve','route' => 'admin.payment-requests.approve','url' => 'admin/payment-requests/approve','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '551','display_title' => 'Admin payment-requests feedback','route' => 'admin.payment-requests.feedback','url' => 'admin/payment-requests/feedback','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '552','display_title' => 'Admin payment-requests reject','route' => 'admin.payment-requests.reject','url' => 'admin/payment-requests/reject','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '553','display_title' => 'Admin payment-requests reSubmit','route' => 'admin.payment-requests.reSubmit','url' => 'admin/payment-requests/reSubmit','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '554','display_title' => 'Admin systemUpdate health-check','route' => 'admin.systemUpdate.health-check','url' => 'admin/writerap/health-check','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '555','display_title' => 'Admin systemUpdate update','route' => 'admin.systemUpdate.update','url' => 'admin/writerap/update','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '556','display_title' => 'Admin systemUpdate file-permission','route' => 'admin.systemUpdate.file-permission','url' => 'admin/writerap/file-permission','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '557','display_title' => 'Admin systemUpdate oneClickUpdate','route' => 'admin.systemUpdate.oneClickUpdate','url' => 'admin/writerap/one-click-update','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '558','display_title' => 'Admin systemUpdate update-version','route' => 'admin.systemUpdate.update-version','url' => 'admin/writerap/manual-update-system','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '559','display_title' => '','route' => 'picture/api','url' => 'picture/api','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '560','display_title' => 'Api logmanager','route' => 'api.logmanager','url' => 'api/v1/logmanager','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '561','display_title' => 'Admin logs index','route' => 'admin.logs.index','url' => 'admin/logs','method_type' => 'GET','is_sidebar_menu' => '1','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '562','display_title' => 'Admin logs dashboard','route' => 'admin.logs.dashboard','url' => 'admin/logs/dashboard','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '563','display_title' => 'Admin logs folder','route' => 'admin.logs.folder','url' => 'admin/logs/{folderName}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '564','display_title' => 'Admin logs file','route' => 'admin.logs.file','url' => 'admin/logs/{folderName}/{fileName}','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '565','display_title' => 'Admin connectWP','route' => 'admin.connectWP','url' => 'admin/connect-wp','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '566','display_title' => 'Admin sync all users','route' => 'admin.sync.all.users','url' => 'admin/sync-all-users','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '567','display_title' => 'Admin wordpress authorLists','route' => 'admin.wordpress.authorLists','url' => 'admin/wordpress/authors','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '568','display_title' => 'Admin wordpress syncAllUsers','route' => 'admin.wordpress.syncAllUsers','url' => 'admin/wordpress/authors/sync-all-users','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '569','display_title' => 'Admin wordpress list','route' => 'admin.wordpress.list','url' => 'admin/wordpress/articles','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '570','display_title' => 'Admin wordpress articles edit','route' => 'admin.wordpress.articles.edit','url' => 'admin/wordpress/articles/edit/{id}/wordpress-article','method_type' => 'GET','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58'),
            array('id' => '571','display_title' => 'Admin wordpress importArticle','route' => 'admin.wordpress.importArticle','url' => 'admin/wordpress/articles/import-article','method_type' => 'POST','is_sidebar_menu' => '0','icon_file' => NULL,'user_id' => '1','is_active' => '0','is_allowed_in_demo' => '1','created_by_id' => '1','updated_by_id' => NULL,'deleted_at' => NULL,'created_at' => '2025-01-28 06:37:58','updated_at' => '2025-01-28 06:37:58')
        );

        DB::table('permissions')->insert($permissions);
    }
}
