#!/bin/bash

set -e

echo "🚀 Starting Laravel packaging process..."

ROUTE_FILE="app/Providers/RouteServiceProvider.php"
BACKUP_FILE="${ROUTE_FILE}.bak"
NEW_FILE="installer_route_service_provider.txt"
ZIP_NAME="install_this.zip"

# 1. Backup original RouteServiceProvider.php
echo "💾 Backing up original RouteServiceProvider.php to $BACKUP_FILE"
cp "$ROUTE_FILE" "$BACKUP_FILE"

# 2. Replace entire RouteServiceProvider.php
echo "✍️ Replacing entire RouteServiceProvider.php with $NEW_FILE"
cp "$NEW_FILE" "$ROUTE_FILE"

# 3. Clear Laravel caches
echo "🧹 Clearing Laravel caches..."
php artisan config:clear
php artisan cache:clear
php artisan route:clear
php artisan view:clear
rm -rf bootstrap/cache/*.php
composer dump-autoload

echo "✅ Laravel caches cleared."

# 4. Clean storage/logs folder
echo "🗑️ Cleaning storage/logs..."
rm -rf storage/logs/*
touch storage/logs/.gitkeep  # So folder is included in zip

# 5. Create ZIP package including vendor, .env, and storage/logs
echo "📦 Creating ZIP package: $ZIP_NAME"
zip -r "$ZIP_NAME" . \
    -x "node_modules/*" \
    -x ".git/*" \
    -x "$ZIP_NAME"

echo "🎉 Laravel package is ready: $ZIP_NAME"