(async function () {
    const scriptTag = document.currentScript;
    const src = scriptTag.getAttribute('src');
    const url = new URL(src, window.location.href); // Base it on the current page
    const chatUUID  = scriptTag.getAttribute('data-chatbot-uuid');

    const chatbotHostOrigin = `${url.origin}`;
    const iframeUrl         = `${chatbotHostOrigin}/chatbot/${chatUUID}`;
    const apiURL            = `${chatbotHostOrigin}/chatbot/details/${chatUUID}`;

    // chatbot config options
    var options = {
        active: false,
        color: '#763ed1',
        trigger_avatar_size: '60px',
        avatar: null,
        trigger_background: ''
    };

    // get chatbot details
    const getChatbotDetails = async () => {
        if (chatUUID) {
            try {
                const response = await fetch(`${apiURL}`);
                const data     = await response.json();
                const chatbot  = data?.data || {};

                options = {
                    ...options,
                    ...chatbot
                };
                 
            } catch (error) {
                console.error('Failed to fetch chatbot details:', error);
                return null;
            }
        }
        return null;
    };

    await getChatbotDetails();
    
 
    // Create a container for the chat box
    const chatContainer = document.createElement('div');
    chatContainer.innerHTML = `
        <style>
            /* Chat Wrapper */
            .chat_box_area {
                position: relative;
                z-index: 999;
            }
            .chat_content {
                background: ${options.color_code};
                padding: 10px 20px;
                border-radius: 12px;
                position: fixed;
                right: 120px;
                bottom: 140px;
            }
            .chat_wrapper {
                position: fixed;
                right: 120px;
                bottom: 130px;
                border-radius: 12px;
                opacity: 0;
                visibility: hidden;
            }
            .chat_wrapper.show {
                opacity: 1;
                visibility: visible;
            }
            .iframe-container {
                width: 450px;
                height: 560px;
            }
            .iframe-container .iframe {
                border: 0;
                width: 100%;
                height: 100%;
            }
            /* Chat Wrapper */

            /* Chat Btn */
            .chat_btn {
                padding: 10px;
                width: 66px;
                height: 66px;
                background: ${options.color_code};
                border: 0;
                border-radius: 100%;
                display: flex;
                align-items: center;
                justify-content: center;
                cursor: pointer;
                margin-left: auto;
                margin-right: auto;
                position: fixed;
                right: 115px;
                bottom: 60px;
            }
            .chat_btn img {
                width: 100%;
                border-radius:50%;
            }
            @media (max-width: 575px) {
                .iframe-container {
                    width: 320px;
                }
                .chat_content,
                .chat_wrapper,
                .chat_btn  {
                    right:25px;
                }
            }
        </style>

        <div class="chat_box_area">   
            <div class="chat_content">
                <h5>${options.welcome_message}</h5>
            </div>
            <div class="chat_wrapper">
                <div class="iframe-container">
                    <iframe class="iframe" src="${iframeUrl}" allowfullscreen></iframe>
                </div>
            </div>
            <button class="chat_btn">
                    <img src="${options.avatarUrl}" alt="" class="">
            </button>
        </div>
    `;

    // Append the chat container to the body
    document.body.appendChild(chatContainer);

    // Show Hide ChatBox
    const chatBtn = document.querySelector(".chat_btn");
    const ChatBody = document.querySelector(".chat_wrapper");

    chatBtn.addEventListener("click", function() {
        ChatBody.classList.toggle("show");
    }); 
})();